package com.cv.media.c.dao.dao;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.cv.media.c.dao.model.WatchListAlbum;

import java.util.List;

@Dao
public abstract class WatchListAlbumDao {

    @Query("SELECT * FROM WatchListAlbum WHERE subAccountId == :subAccountId ORDER BY addTime DESC")
    public abstract List<WatchListAlbum> loadWatchListAlbum(long subAccountId);

    @Query("SELECT * FROM WatchListAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId")
    public abstract List<WatchListAlbum> loadAllWatchListAlbum(long accountId, long subAccountId);

    @Query("SELECT COUNT(*) FROM WatchListAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId")
    public abstract int getAllWatchListAlbumCount(long accountId, long subAccountId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertWatchListAlbum(WatchListAlbum...profileAlbum);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertWatchListAlbumList(List<WatchListAlbum> watchListAlbumList);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    public abstract void updateWatchListAlbum(WatchListAlbum...profileAlbum);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    public abstract void updateWatchListAlbumList(List<WatchListAlbum> watchListAlbumList);

    @Query("SELECT * FROM WatchListAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId AND metaId == :metaId ")
    public abstract WatchListAlbum loadWatchListAlbum(long accountId, long subAccountId, long metaId);

    @Query("SELECT * FROM WatchListAlbum WHERE subAccountId == :subAccountId ORDER BY addTime DESC LIMIT :size")
    public abstract List<WatchListAlbum> loadWatchListAlbumBySize(long subAccountId, int size);

    @Delete
    public abstract void delete(WatchListAlbum...profileAlbum);

    @Query("DELETE FROM WatchListAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId")
    public abstract void deleteAll(long accountId, long subAccountId);

    @Query("DELETE FROM WatchListAlbum WHERE metaId == :metaId")
    public abstract void deleteById(long metaId);

    @Query("DELETE FROM WatchListAlbum")
    public abstract void clearWatchListDb();

}
