package com.cv.media.c.dao.converter;

import androidx.room.TypeConverter;

import com.cv.media.c.dao.enums.EnumDownloadUserType;
import com.cv.media.lib.storage.GsonInstance;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;

public class EnumDownloadUserTypeConverter {
    @TypeConverter
    public String objectToString(EnumDownloadUserType type) {
        return GsonInstance.getInstance().getGson().toJson(type);
    }

    @TypeConverter
    public EnumDownloadUserType stringToObject(String json) {
        Type listType = new TypeToken<EnumDownloadUserType>(){}.getType();
        return GsonInstance.getInstance().getGson().fromJson(json, listType);
    }
}
