
package com.cv.media.c.dao;

import androidx.room.Database;
import androidx.room.RoomDatabase;

import com.cv.media.c.dao.dao.FavoriteAlbumDao;
import com.cv.media.c.dao.dao.HistoryAlbumDao;
import com.cv.media.c.dao.dao.SubDao;
import com.cv.media.c.dao.dao.WatchListAlbumDao;
import com.cv.media.c.dao.download.DownloadDao;
import com.cv.media.c.dao.message.dao.AdDao;
import com.cv.media.c.dao.message.dao.MessageDao;
import com.cv.media.c.dao.message.model.Message;
import com.cv.media.c.dao.model.AdMessage;
import com.cv.media.c.dao.model.DownloadInfo;
import com.cv.media.c.dao.model.FavoriteAlbum;
import com.cv.media.c.dao.model.HistoryAlbum;
import com.cv.media.c.dao.model.ProfileAlbum;
import com.cv.media.c.dao.model.SubInfo;
import com.cv.media.c.dao.model.WatchListAlbum;

/**
 * Created by zhangyaoa on 2020/6/3.
 */
@Database(entities = { DownloadInfo.class, SubInfo.class, AdMessage.class, Message.class
        , HistoryAlbum.class, FavoriteAlbum.class, WatchListAlbum.class},
        version = 1, exportSchema = false)
public abstract class PublicDatabase extends RoomDatabase {
    public abstract DownloadDao getDownloadDao();

    public abstract SubDao getSubDao();

    public abstract HistoryAlbumDao getHistoryAlbumDao();

    public abstract FavoriteAlbumDao getFavoriteAlbumDao();

    public abstract WatchListAlbumDao getWatchListAlbumDao();

    public abstract AdDao getAdDao();

    public abstract MessageDao getMessageDao();
}
