package com.cv.media.c.dao.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;

import com.cv.media.c.dao.converter.EnumDownloadStatusConverter;
import com.cv.media.c.dao.enums.EnumDownloadStatus;
import com.cv.media.c.server.response.AbstractPrintable;

/**
 * Created by Joyce on 2021/11/2.
 */
@Entity(tableName = "DownloadInfo")
public class DownloadInfo extends AbstractPrintable {

    //todo 为了兼容老id的业务逻辑id
    @PrimaryKey
    @NonNull
    public String id;
    //关联资源ID，比如Cloud media file id或者torrent info id
    public String resourceId;
    private long cid;
    //todo 这个命名后续需要改
    public long albumId;// 影片ID 相当于metaId
    public String ttid; //ttId
    public int season = -1;//季，默认值-1，默认电影
    public int episode = -1;//集，默认值-1，默认电影
    public String quality;
    public String videoType;// 影片类型
    public String title;// 影片名称
    public String picUrl;// 影片图片路径
    public String site;
    public String acct;
    public String resName; // 资源名称
    public String format;
    public String extra;
    public String decodeKey; // 解密密码
    public long fileTimestamp;

    //本地保存的目录
    public String savePath;
    //文件尺寸
    public long fileSize = 0;//byte
    //下载数据量 byte
    public long bytesReceived;
    //下载速度 byte/s
    public long downloadSpeed;
    //下载时间预估 second
    public long downloadETA;
    //下载进度 百分比：0-100
    public int downloadProgress;
    //参考：DownloadConstant
    @TypeConverters(EnumDownloadStatusConverter.class)
    public EnumDownloadStatus status;
    public String message;
    //最后失败时间
//    @TypeConverters(DateConverter.class)
    public long failedDate;
    //失败次数
    public int failedCount;
//    @TypeConverters(DateConverter.class)
    public long createDate;
//    @TypeConverters(DateConverter.class)
    public long updateDate;

    //显示属性
    public String displayMode;

    //资源hash
    public String channelHash;
    //下载方式/PM or mrt
    public String mediaPlayType;
    //cache影片上一次播放进度
    public long lastPlayProgress;
    //分辨率
    public String resolution;
    //audio lang
    public String audioLang;
    //评分
    public double rating;

    public String genre;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResourceId() {
        return resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public long getCid() {
        return cid;
    }

    public void setCid(long cid) {
        this.cid = cid;
    }

    public long getAlbumId() {
        return albumId;
    }

    public void setAlbumId(long albumId) {
        this.albumId = albumId;
    }

    public String getTtid() {
        return ttid;
    }

    public void setTtid(String ttid) {
        this.ttid = ttid;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }

    public String getQuality() {
        return quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getVideoType() {
        return videoType;
    }

    public void setVideoType(String videoType) {
        this.videoType = videoType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getAcct() {
        return acct;
    }

    public void setAcct(String acct) {
        this.acct = acct;
    }

    public String getResName() {
        return resName;
    }

    public void setResName(String resName) {
        this.resName = resName;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getDecodeKey() {
        return decodeKey;
    }

    public void setDecodeKey(String decodeKey) {
        this.decodeKey = decodeKey;
    }

    public long getFileTimestamp() {
        return fileTimestamp;
    }

    public void setFileTimestamp(long fileTimestamp) {
        this.fileTimestamp = fileTimestamp;
    }

    public String getSavePath() {
        return savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public long getFileSize() {
        return fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getBytesReceived() {
        return bytesReceived;
    }

    public void setBytesReceived(long bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public long getDownloadSpeed() {
        return downloadSpeed;
    }

    public void setDownloadSpeed(long downloadSpeed) {
        this.downloadSpeed = downloadSpeed;
    }

    public long getDownloadETA() {
        return downloadETA;
    }

    public void setDownloadETA(long downloadETA) {
        this.downloadETA = downloadETA;
    }

    public int getDownloadProgress() {
        return downloadProgress;
    }

    public void setDownloadProgress(int downloadProgress) {
        this.downloadProgress = downloadProgress;
    }

    public EnumDownloadStatus getStatus() {
        return status;
    }

    public void setStatus(EnumDownloadStatus status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public long getFailedDate() {
        return failedDate;
    }

    public void setFailedDate(long failedDate) {
        this.failedDate = failedDate;
    }

    public int getFailedCount() {
        return failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public long getCreateDate() {
        return createDate;
    }

    public void setCreateDate(long createDate) {
        this.createDate = createDate;
    }

    public long getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(long updateDate) {
        this.updateDate = updateDate;
    }

    public String getDisplayMode() {
        return displayMode;
    }

    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode;
    }

    public String getChannelHash() {
        return channelHash;
    }

    public void setChannelHash(String channelHash) {
        this.channelHash = channelHash;
    }

    public String getMediaPlayType() {
        return mediaPlayType;
    }

    public void setMediaPlayType(String mediaPlayType) {
        this.mediaPlayType = mediaPlayType;
    }


    public long getLastPlayProgress() {
        return lastPlayProgress;
    }

    public void setLastPlayProgress(long lastPlayProgress) {
        this.lastPlayProgress = lastPlayProgress;
    }

    public String getResolution() {
        return resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getAudioLang() {
        return audioLang;
    }

    public void setAudioLang(String audioLang) {
        this.audioLang = audioLang;
    }

    public double getRating() {
        return rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public String getGenre() {
        return genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    @Override
    public String toString() {
        return "DownloadInfo{" +
                "id='" + id + '\'' +
                ", resourceId='" + resourceId + '\'' +
                ", cid='" + cid + '\'' +
                ", albumId=" + albumId +
                ", ttid='" + ttid + '\'' +
                ", season=" + season +
                ", episode=" + episode +
                ", quality='" + quality + '\'' +
                ", videoType='" + videoType + '\'' +
                ", title='" + title + '\'' +
                ", picUrl='" + picUrl + '\'' +
                ", site='" + site + '\'' +
                ", acct='" + acct + '\'' +
                ", resName='" + resName + '\'' +
                ", format='" + format + '\'' +
                ", extra='" + extra + '\'' +
                ", decodeKey='" + decodeKey + '\'' +
                ", fileTimestamp=" + fileTimestamp +
                ", savePath='" + savePath + '\'' +
                ", fileSize=" + fileSize +
                ", bytesReceived=" + bytesReceived +
                ", downloadSpeed=" + downloadSpeed +
                ", downloadETA=" + downloadETA +
                ", downloadProgress=" + downloadProgress +
                ", status=" + status +
                ", message='" + message + '\'' +
                ", failedDate=" + failedDate +
                ", failedCount=" + failedCount +
                ", createDate=" + createDate +
                ", updateDate=" + updateDate +
                ", displayMode='" + displayMode + '\'' +
                ", channelHash='" + channelHash + '\'' +
                ", mediaPlayType='" + mediaPlayType + '\'' +
                ", lastPlayProgress='" + lastPlayProgress + '\'' +
                ", resolution='" + resolution + '\'' +
                ", audioLang='" + audioLang + '\'' +
                ", rating='" + rating + '\'' +
                ", genre='" + genre + '\'' +
                '}';
    }
}
