package com.cv.media.c.dao.message.model;

import androidx.databinding.ObservableField;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;

import com.cv.media.c.server.response.AbstractPrintable;

@Entity
public class Message extends AbstractPrintable {
    @PrimaryKey
    private Long msgId;
    private String title;
    private Integer msgType;
    private Integer msgLanguage;
    private Integer bizType;
    private String digest;
    private String createTime;
    private String expiredDate;
    private Integer status;
    private Integer rank = 3;
    @Ignore
    public ObservableField<Boolean> selected = new ObservableField<>(false);
    @Ignore
    public ObservableField<Boolean> hasRead = new ObservableField<>(false);

    public Message() {
    }

    public Long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getMsgType() {
        return this.msgType;
    }

    public void setMsgType(Integer msgType) {
        this.msgType = msgType;
    }

    public Integer getMsgLanguage() {
        return this.msgLanguage;
    }

    public void setMsgLanguage(Integer msgLanguage) {
        this.msgLanguage = msgLanguage;
    }

    public Integer getBizType() {
        return this.bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getExpiredDate() {
        return this.expiredDate;
    }

    public void setExpiredDate(String expiredDate) {
        this.expiredDate = expiredDate;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
        hasRead.set(status == 1);
    }

    public Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public ObservableField<Boolean> isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public ObservableField<Boolean> hasRead() {
        hasRead.set(status == 1);
        return hasRead;
    }
}