package com.cv.media.c.dao.notify;

import java.util.Objects;

public class NoticeInfo {
    private int showTimes;//预定显示次数
    private int finishTimes;//已经完成次数
    private NoticeDO noticeDO;

    public NoticeInfo(NoticeDO noticeDO, int showTimes, int finishTimes) {
        this.noticeDO = noticeDO;
        this.showTimes = showTimes;
        this.finishTimes = finishTimes;
    }

    public int getShowTimes() {
        return showTimes;
    }

    public void setShowTimes(int showTimes) {
        this.showTimes = showTimes;
    }

    public int getFinishTimes() {
        return finishTimes;
    }

    public void setFinishTimes(int finishTimes) {
        this.finishTimes = finishTimes;
    }

    public NoticeDO getNoticeDO() {
        return noticeDO;
    }

    public void setNoticeDO(NoticeDO noticeDO) {
        this.noticeDO = noticeDO;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NoticeInfo that = (NoticeInfo) o;
        return showTimes == that.showTimes && finishTimes == that.finishTimes && Objects.equals(noticeDO, that.noticeDO);
    }

    @Override
    public String toString() {
        return "NoticeInfo{" +
                "noticeDO=" + noticeDO +
                '}';
    }
}
