package com.cv.media.c.dao.model;

import androidx.room.Entity;
import androidx.room.PrimaryKey;

import com.cv.media.c.server.response.AbstractPrintable;
import com.cv.media.lib.common_utils.obfuscation.KeepClassMember;

/**
 * 服务器返回的profile数据 model
 */
public class ProfileAlbum extends AbstractPrintable implements KeepClassMember {
    /** 影片id */
    @PrimaryKey
    protected long metaId;

    /** 账号id */
    protected long accountId;

    /** 子账号id */
    protected long subAccountId;

    /** 标题 */
    protected String title;

    /** 海报 */
    protected String poster;

    /** 背景 */
    protected String backdrop;

    /** 评分 */
    protected double rating;

    /** 是否链接 0:无链接,1:有链接 */
    protected int linked;

    /** 上下线状态 0:上线,1:下线 */
    protected int status;

    /** 影片类型 EVideoType */
    protected String videoType;

    /** 集 */
    protected int episodeNo = -1;

    /** 季 */
    protected int seasonNo = -1;

    /** 添加时间戳 */
    protected long addTime;

    /** 影片总时长, 单位:ms */
    protected int duration;

    /** 播放时长, 单位: ms */
    protected int collectionTime;

    /** 停止播放的时间戳 */
    protected long playedTime;

    /** 观看状态 0:观看中,1:已看完 */
    protected int watchStatus;

    /** 上次播放的playsource对应的cid */
    protected long cid;

    /** 上次播放的playsource对应的id */
    protected String resId;

    /** 分辨率（用户选择） */
    protected String resolution;

    /** audio语言（用户选择） */
    protected String videoLangs;

    public int getProgress() {
        return duration == 0 ? 0 : (int) ((collectionTime * 100.0f) / duration);
    }

    public long getAccountId() {
        return accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public long getSubAccountId() {
        return subAccountId;
    }

    public void setSubAccountId(long subAccountId) {
        this.subAccountId = subAccountId;
    }

    public long getMetaId() {
        return metaId;
    }

    public void setMetaId(long metaId) {
        this.metaId = metaId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPoster() {
        return poster;
    }

    public void setPoster(String poster) {
        this.poster = poster;
    }

    public String getBackdrop() {
        return backdrop;
    }

    public void setBackdrop(String backdrop) {
        this.backdrop = backdrop;
    }

    public double getRating() {
        return rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public int getLinked() {
        return linked;
    }

    public void setLinked(int linked) {
        this.linked = linked;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getVideoType() {
        return videoType;
    }

    public void setVideoType(String videoType) {
        this.videoType = videoType;
    }

    public int getEpisodeNo() {
        return episodeNo;
    }

    public void setEpisodeNo(int episodeNo) {
        this.episodeNo = episodeNo;
    }

    public int getSeasonNo() {
        return seasonNo;
    }

    public void setSeasonNo(int seasonNo) {
        this.seasonNo = seasonNo;
    }

    public long getAddTime() {
        return addTime;
    }

    public void setAddTime(long addTime) {
        this.addTime = addTime;
    }

    public int getDuration() {
        return duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getCollectionTime() {
        return collectionTime;
    }

    public void setCollectionTime(int collectionTime) {
        this.collectionTime = collectionTime;
    }

    public long getPlayedTime() {
        return playedTime;
    }

    public void setPlayedTime(long playedTime) {
        this.playedTime = playedTime;
    }

    public int getWatchStatus() {
        return watchStatus;
    }

    public void setWatchStatus(int watchStatus) {
        this.watchStatus = watchStatus;
    }

    public long getCid() {
        return cid;
    }

    public void setCid(long cid) {
        this.cid = cid;
    }

    public String getResId() {
        return resId;
    }

    public void setResId(String resId) {
        this.resId = resId;
    }

    public String getResolution() {
        return resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getVideoLangs() {
        return videoLangs;
    }

    public void setVideoLangs(String videoLangs) {
        this.videoLangs = videoLangs;
    }
}
