package com.cv.media.c.server.basenet;

import com.cv.media.c.server.SGSEManager;
import com.cv.media.c.server.exception.ServerException;
import com.cv.media.c.server.response.ResponseStatus;
import com.cv.media.lib.common_utils.obfuscation.KeepClassMember;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

/**
 * [网络请求基类]
 *
 * @author Mac Xu
 * @Date 2023/02/21
 */
public abstract class BaseRequest<T, E extends BaseEvent> implements KeepClassMember {

    /**
     * 请求参数
     */
    protected E event;

    /**
     * 请求回调
     */
    protected final BaseCallback<E, T> callback;

    public BaseRequest(BaseCallback<E, T> callback) {
        this.callback = callback;
    }

    public BaseRequest(E event, BaseCallback<E, T> callback) {
        this.event = event;
        this.callback = callback;
    }

    /**
     * 发起请求
     */
    public void request() {
        if(RequestBlock.getInstance().blockRequest()){
            return;
        }
        Observable<T> request = getRequest();
        request.subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Observer<T>() {
                    @Override
                    public void onSubscribe(Disposable d) {

                    }

                    @Override
                    public void onNext(T value) {
                        if (value instanceof ResponseStatus) {
                            ResponseStatus responseData = (ResponseStatus) value;
                            if (responseData.getCode().equals("00000")) {
                                callback.onSuccess(event, value);
                            } else {
                                SGSEManager.getInstance().handleResponse(responseData.getCode());
                                callback.onFailure(event, responseData.getCode(), responseData.getMsg());
                            }
                        }

                    }

                    @Override
                    public void onError(Throwable e) {
                        if (e instanceof ServerException) {
                            ServerException serverException = (ServerException) e;
                            int httpCode = serverException.getHttpCode();
                            ResponseStatus responseStatus = serverException.getResponseStatus();
                            SGSEManager.getInstance().handleResponse(responseStatus.getCode());
                            callback.onFailure(event, httpCode + ":" + responseStatus.getCode(), responseStatus.getMsg());
                        } else {
                            callback.onFailure(event, "", e.toString());
                        }
                    }

                    @Override
                    public void onComplete() {

                    }
                });
    }

    protected abstract Observable<T> getRequest();
}
