package com.cv.media.c.server.callback;

import java.util.Objects;

/**
 * 移植java.util.function.BiConsumer
 *
 * @param <T>
 * @param <U>
 */
public interface BiConsumer<T, U> {
    void accept(T t, U u);

    default BiConsumer<T, U> andThen(BiConsumer<? super T, ? super U> after) {
        Objects.requireNonNull(after);

        return (l, r) -> {
            accept(l, r);
            after.accept(l, r);
        };
    }
}
