package com.cv.media.c.server.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

import com.cv.media.lib.common_utils.obfuscation.KeepAll;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 播放器播放数据源信息
 */
public class PlayInfo implements Parcelable, KeepAll {

    private boolean isTrailer;
    private long videoId; //这里是整体的ID（其他值类似）而不是具体播放剧集的（虽然单季单集是一样的）
    private String videoType;//EVideoType
    private long seasonId;
    private long episodeId;
    private int season = 1;//default
    private int episode;
    private long resumeTime = 0;//恢复播放时点
    private boolean isLoadSubtitles = true;//是否需要加载字幕
    private String title;
    private String url;//播放地址
    private String ttid;
    private String posterUrl;//海报地址
    private String masterBackdrop;//主剧照，横图背景
    private ArrayList<String> backdrops;//剧照地址列表
    private ArrayList<String> playPauseAdUrls; //播放暂停广告地址列表
    private String resourceSite;
    private String resourceAccount;
    private String resourceId;
    private String resourceName;
    private String decodeKey;
    private String audioLanguage; // 音频语言
    private String extra1;//预留数据字段1
    private String extra2;//预留数据字段2
    private String extra3;//预留数据字段3
    private boolean isLinked;//是否有资源
    private boolean isLocalFile = false;// 是否是本地磁盘文件
    private String userAgent;//是否指定userAgent
    private boolean handleMore;//播放需要通过回调进一步加工
    private boolean preload = true;//预先缓存数据到本地
    private ArrayList<String> backdropUrls;//剧照地址列表
    private String hlsKey;
    private String videoLayout;//屏幕拉伸参数
    private String displayMode; // show3D | hide3D     是否3D等显示方式定义
    private String protocol;// 播放方式
    private long size = -1;//视频文件大小
    private boolean isAutoStart = false;//是否自动播放
    private boolean isBufferingEnable = false;// 是否允许强制缓冲
    private String serverId; // 标识playUrl是从哪个server过来的
    private boolean isEngineCached = false;
    private String channelHash;
    private String feedBackId;//用于播放页面上报
    private boolean isCDNCached;
    private String savePath;
    private int pmCiperBufferSize = 512;//prt每次推送block数据给播放器buffer大小
    private Map<String, Object> params = new HashMap<>();
    private String resolution;
    private double rating = 0.0;
    private String genre;

    public PlayInfo() {

    }

    public PlayInfo(boolean isTrailer, long videoId, long episodeId, long episode,
                    String title, String url, long resumeTime, ArrayList<String> backdrops) {
        this.isTrailer = isTrailer;
        this.videoId = videoId;
        this.ttid = null;
        this.title = title;
        this.url = url;
        this.resumeTime = resumeTime;
        setBackdrops(backdrops);
        this.episodeId = episodeId;
        this.episode = (int) episode;
        this.season = 1;//default
    }

    protected PlayInfo(Parcel in) {
        Bundle bundle = in.readBundle();
        url = bundle.getString("Url");
        isTrailer = bundle.getBoolean("IsTrailer");
        videoId = bundle.getLong("VideoId");
        videoType = bundle.getString("VideoType");
        title = bundle.getString("Title");
        resumeTime = bundle.getLong("ResumeTime");
        backdrops = bundle.getStringArrayList("Backdrops");
        playPauseAdUrls = bundle.getStringArrayList("PlayPauseAdUrls");
        seasonId = bundle.getLong("SeasonId");
        episodeId = bundle.getLong("EpisodeId");
        season = bundle.getInt("Season");
        episode = bundle.getInt("Episode");
        ttid = bundle.getString("ttid");
        posterUrl = bundle.getString("PosterUrl");
        resourceSite = bundle.getString("ResourceSite");
        resourceAccount = bundle.getString("ResourceAccount");
        resourceId = bundle.getString("ResourceId");
        resourceName = bundle.getString("ResourceName");
        decodeKey = bundle.getString("DecodeKey");
        audioLanguage = bundle.getString("AudioLanguage");
        isLoadSubtitles = bundle.getBoolean("IsLoadSubtitles");
        extra1 = bundle.getString("Extra1");
        extra2 = bundle.getString("Extra2");
        extra3 = bundle.getString("Extra3");
        isLinked = bundle.getBoolean("IsLinked");
        isLocalFile = bundle.getBoolean("IsLocalFile");
        userAgent = bundle.getString("UserAgent");
        handleMore = bundle.getBoolean("HandleMore");
        preload = bundle.getBoolean("Preload");
        backdropUrls = bundle.getStringArrayList("BackdropUrls");
        hlsKey = bundle.getString("HlsKey");
        videoLayout = bundle.getString("VideoLayout");
        displayMode = bundle.getString("DisplayMode");
        protocol = bundle.getString("Protocol");
        size = bundle.getLong("Size");
        isAutoStart = bundle.getBoolean("IsAutoStart");
        isBufferingEnable = bundle.getBoolean("IsBufferingEnable");
        serverId = bundle.getString("ServerId");
        isEngineCached = bundle.getBoolean("IsEngineCached");
        channelHash = bundle.getString("ChannelHash");
        feedBackId = bundle.getString("FeedBackId");
        isCDNCached = bundle.getBoolean("IsCDNCached");
        savePath = bundle.getString("SavePath");
        pmCiperBufferSize = bundle.getInt("PmCiperBufferSize");
        resolution = bundle.getString("Resolution");
        rating = bundle.getDouble("Rating");
        genre = bundle.getString("Genre");
    }

    public static final Creator<PlayInfo> CREATOR = new Creator<PlayInfo>() {
        @Override
        public PlayInfo createFromParcel(Parcel in) {
            return new PlayInfo(in);
        }

        @Override
        public PlayInfo[] newArray(int size) {
            return new PlayInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("IsTrailer", isTrailer);
        bundle.putLong("VideoId", videoId);
        bundle.putString("VideoType", videoType);
        bundle.putString("Url", url);
        bundle.putString("Title", title);
        bundle.putLong("ResumeTime", resumeTime);
        bundle.putStringArrayList("Backdrops", backdrops);
        bundle.putStringArrayList("PlayPauseAdUrls", playPauseAdUrls);
        bundle.putLong("SeasonId", seasonId);
        bundle.putLong("EpisodeId", episodeId);
        bundle.putInt("Season", season);
        bundle.putInt("Episode", episode);
        bundle.putString("ttid", ttid);
        bundle.putString("PosterUrl", posterUrl);
        bundle.putString("ResourceSite", resourceSite);
        bundle.putString("ResourceAccount", resourceAccount);
        bundle.putString("ResourceId", resourceId);
        bundle.putString("ResourceName", resourceName);
        bundle.putString("DecodeKey", decodeKey);
        bundle.putString("AudioLanguage", audioLanguage);
        bundle.putBoolean("IsLoadSubtitles", isLoadSubtitles);
        bundle.putString("Extra1", extra1);
        bundle.putString("Extra2", extra2);
        bundle.putString("Extra3", extra3);
        bundle.putBoolean("IsLinked", isLinked);
        bundle.putBoolean("IsLocalFile", isLocalFile);
        bundle.putString("UserAgent", userAgent);
        bundle.putBoolean("HandleMore", handleMore);
        bundle.putBoolean("Preload", preload);
        bundle.putStringArrayList("BackdropUrls", backdropUrls);
        bundle.putString("HlsKey", hlsKey);
        bundle.putString("VideoLayout", videoLayout);
        bundle.putString("DisplayMode", displayMode);
        bundle.putString("Protocol", protocol);
        bundle.putLong("Size", size);
        bundle.putBoolean("IsAutoStart", isAutoStart);
        bundle.putBoolean("IsBufferingEnable", isBufferingEnable);
        bundle.putString("ServerId", serverId);
        bundle.putBoolean("IsEngineCached", isEngineCached);
        bundle.putString("ChannelHash", channelHash);
        bundle.putString("FeedBackId", feedBackId);
        bundle.putBoolean("IsCDNCached", isCDNCached);
        bundle.putString("SavePath", savePath);
        bundle.putInt("PmCiperBufferSize", pmCiperBufferSize);
        bundle.putString("Resolution", resolution);
        bundle.putDouble("Rating", rating);
        bundle.putString("Genre", genre);
        dest.writeBundle(bundle);
    }

    public boolean isTrailer() {
        return isTrailer;
    }

    public void setTrailer(boolean trailer) {
        isTrailer = trailer;
    }

    public long getVideoId() {
        return videoId;
    }

    public void setVideoId(long videoId) {
        this.videoId = videoId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public long getResumeTime() {
        return resumeTime;
    }

    public void setResumeTime(long resumeTime) {
        this.resumeTime = resumeTime;
    }

    public ArrayList<String> getBackdrops() {
        return backdrops;
    }

    public String getMasterBackDrop(){
        return masterBackdrop;
    }

    public void setMasterBackdrop(String masterBackdrop) {
        this.masterBackdrop = masterBackdrop;
    }

    public void setBackdrops(ArrayList<String> backdrops) {
        this.backdrops = backdrops;
    }

    public ArrayList<String> getPlayPauseAdUrls() {
        return playPauseAdUrls;
    }

    public void setPlayPauseAdUrls(ArrayList<String> playPauseAdUrls) {
        this.playPauseAdUrls = playPauseAdUrls;
    }

    public long getEpisodeId() {
        return episodeId;
    }

    public void setEpisodeId(long episodeId) {
        this.episodeId = episodeId;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public String getTtid() {
        return ttid;
    }

    public void setTtid(String ttid) {
        this.ttid = ttid;
    }

    public String getPosterUrl() {
        return posterUrl;
    }

    public void setPosterUrl(String posterUrl) {
        this.posterUrl = posterUrl;
    }

    public String getResourceAccount() {
        return resourceAccount;
    }

    public void setResourceAccount(String resourceAccount) {
        this.resourceAccount = resourceAccount;
    }

    public String getResourceSite() {
        return resourceSite;
    }

    public void setResourceSite(String resourceSite) {
        this.resourceSite = resourceSite;
    }

    public String getResourceId() {
        return resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getDecodeKey() {
        return decodeKey;
    }

    public void setDecodeKey(String decodeKey) {
        this.decodeKey = decodeKey;
    }

    public String getVideoType() {
        return videoType;
    }

    public void setVideoType(String videoType) {
        this.videoType = videoType;
    }

    public long getSeasonId() {
        return seasonId;
    }

    public void setSeasonId(long seasonId) {
        this.seasonId = seasonId;
    }

    public String getExtra1() {
        return extra1;
    }

    public void setExtra1(String extra1) {
        this.extra1 = extra1;
    }

    public String getExtra2() {
        return extra2;
    }

    public void setExtra2(String extra2) {
        this.extra2 = extra2;
    }

    public String getExtra3() {
        return extra3;
    }

    public void setExtra3(String extra3) {
        this.extra3 = extra3;
    }

    public boolean isLoadSubtitles() {
        return isLoadSubtitles;
    }

    public void setLoadSubtitles(boolean loadSubtitles) {
        isLoadSubtitles = loadSubtitles;
    }

    public boolean isLinked() {
        return isLinked;
    }

    public void setLinked(boolean linked) {
        isLinked = linked;
    }

    public boolean isLocalFile() {
        return isLocalFile;
    }

    public void setLocalFile(boolean localFile) {
        isLocalFile = localFile;
    }

    public String getAudioLanguage() {
        return audioLanguage;
    }

    public void setAudioLanguage(String audioLanguage) {
        this.audioLanguage = audioLanguage;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isHandleMore() {
        return handleMore;
    }

    public void setHandleMore(boolean handleMore) {
        this.handleMore = handleMore;
    }

    public boolean isPreload() {
        return preload;
    }

    public void setPreload(boolean preload) {
        this.preload = preload;
    }

    public ArrayList<String> getBackdropUrls() {
        return backdropUrls;
    }

    public void setBackdropUrls(ArrayList<String> backdropUrls) {
        this.backdropUrls = backdropUrls;
    }

    public String getHlsKey() {
        return hlsKey;
    }

    public void setHlsKey(String hlsKey) {
        this.hlsKey = hlsKey;
    }

    public String getVideoLayout() {
        return videoLayout;
    }

    public void setVideoLayout(String videoLayout) {
        this.videoLayout = videoLayout;
    }

    public String getDisplayMode() {
        return displayMode;
    }

    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode;
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public long getSize() {
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isAutoStart() {
        return isAutoStart;
    }

    public void setAutoStart(boolean autoStart) {
        isAutoStart = autoStart;
    }

    public boolean isBufferingEnable() {
        return isBufferingEnable;
    }

    public void setBufferingEnable(boolean bufferingEnable) {
        isBufferingEnable = bufferingEnable;
    }

    public String getServerId() {
        return serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public boolean isEngineCached() {
        return isEngineCached;
    }

    public void setEngineCached(boolean engineCached) {
        isEngineCached = engineCached;
    }

    public String getChannelHash() {
        return channelHash;
    }

    public void setChannelHash(String channelHash) {
        this.channelHash = channelHash;
    }

    public String getFeedBackId() {
        return feedBackId;
    }

    public void setFeedBackId(String feedBackId) {
        this.feedBackId = feedBackId;
    }

    public boolean isCDNCached() {
        return isCDNCached;
    }

    public void setCDNCached(boolean CDNCached) {
        isCDNCached = CDNCached;
    }

    public String getSavePath() {
        return savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public int getPmCiperBufferSize() {
        return pmCiperBufferSize;
    }

    public void setPmCiperBufferSize(int pmCiperBufferSize) {
        this.pmCiperBufferSize = pmCiperBufferSize;
    }

    public Map<String, Object> getParams() {
        return params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getResolution() {
        return resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public double getRating() {
        return rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }


    public String getGenre() {
        return genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public PlayInfo(String ttid, boolean isTrailer, long videoId, long episodeId, long episode,
                    String title, String url, long resumeTime, ArrayList<String> backdrops) {
        this.isTrailer = isTrailer;
        this.videoId = videoId;
        this.ttid = null;
        this.title = title;
        this.ttid = ttid;
        this.url = url;
        this.resumeTime = resumeTime;
        setBackdrops(backdrops);
        this.episodeId = episodeId;
        this.episode = (int) episode;
        this.season = 1;//default
        this.isLinked = !StringUtils.isEmpty(this.url);
    }

    public PlayInfo(String ttid, long videoId, String videoType, int episodeId, String title
            , int episode, int season, boolean isLinked,
                    long resumeTime, String posterUrl, String genre, ArrayList<String> backdrops) {
        this.isTrailer = false;
        this.videoId = videoId;
        this.videoType = videoType;
        this.episodeId = episodeId;
        this.title = title;
        this.ttid = ttid;
        this.resumeTime = resumeTime;
        setBackdrops(backdrops);
        this.episode = episode;
        this.season = season;
        //todo
        this.posterUrl = posterUrl;
        this.isLinked = isLinked;
        this.genre = genre;
    }

    public PlayInfo(String ttid, double rating, long videoId, String videoType, int episodeId, String title,
            int episode, int season, boolean isLinked, long resumeTime, String posterUrl, ArrayList<String> backdrops) {
        this.isTrailer = false;
        this.videoId = videoId;
        this.videoType = videoType;
        this.episodeId = episodeId;
        this.title = title;
        this.ttid = ttid;
        this.resumeTime = resumeTime;
        setBackdrops(backdrops);
        this.episode = episode;
        this.season = season;
        //todo
        this.posterUrl = posterUrl;
        this.isLinked = isLinked;
        this.rating = rating;
    }

    public PlayInfo(String ttid, long videoId, String videoType, String title, int episode, int season
            , int isLinked, long resumeTime, String posterUrl, String resolution, String audioLanguage,String displayMode) {
        this.isTrailer = false;
        this.videoId = videoId;
        this.videoType = videoType;
        this.title = title;
        this.ttid = ttid;
        this.resumeTime = resumeTime;
        if (!TextUtils.isEmpty(posterUrl)) {
            ArrayList<String> strings = new ArrayList<>(Collections.singletonList(posterUrl));
            setBackdrops(strings);
        }
        this.episode = episode;
        this.season = season;
        this.posterUrl = posterUrl;
        this.isLinked = isLinked == 1;
        this.audioLanguage = audioLanguage;
        this.resolution = resolution;
    }
}
