package com.cv.media.c.server;

import com.cv.media.c.server.model.CommonDeviceInfo;
import com.cv.media.lib.api.BuildConfig;
import com.cv.media.lib.common_utils.utils.AppUtils;
import com.cv.media.lib.common_utils.utils.DeviceUtils;
import com.cv.media.lib.geoip.manager.GeoIPManager;
import com.cv.media.lib.hardware.device.DeviceInfo;
import com.cv.media.lib.hardware.device.HardwareManager;
import com.cv.media.lib.hardware.network.NetworkManager;
import com.google.gson.Gson;

import java.util.HashMap;
import java.util.Map;

import okhttp3.Request;

/**
 * 所有平台共同的公共参数
 * 职责:
 *
 * @author Damon
 */
public class ServerCommonParams {
    protected HashMap<String, String> params;
    protected HashMap<String, String> paramsHeader;
    protected DeviceInfo deviceInfo;

    //todo mfc当前也是直接引用sdk paramsInterceptor，但某些服务获取参数和sdk不一致，合理做法应该在mfc工程中单独另建新的公共参数类，不使用sdk的公共参数类
    //todo 目前时间紧张先这样sdk内部简单兼容处理。下个版本优化
    private boolean mUseOldServerParams;

    public ServerCommonParams(boolean oldServer){
        mUseOldServerParams = oldServer;

        params = new HashMap<>();
        paramsHeader = new HashMap<>();
        deviceInfo = HardwareManager.getInstance().getDeviceInfo();

        if(oldServer){
            loadMFCCommonParams();
        }else {
            loadSdkCommonParams();
        }

        if (BuildConfig.DEBUG) {
            params.put("isDebug", "true");
        }
    }

    private void loadMFCCommonParams(){
        params.put("firmware", deviceInfo.getFirmware());
        params.put("host", deviceInfo.getBuildHost());
        params.put("user", deviceInfo.getBuildUser());
        params.put("device", deviceInfo.getProductDevice());
        params.put("brand", deviceInfo.getProductBrand());
        params.put("model", deviceInfo.getProductModel());
        params.put("hardware", deviceInfo.getHardware());
        params.put("cpuHardware", deviceInfo.getCpuHardware());
        params.put("systemVersion", deviceInfo.getAndroidVersion());
        params.put("sdk", deviceInfo.getSdk() + "");
        params.put("display", deviceInfo.getBuildDisplay());
        params.put("fingerprint", deviceInfo.getBuildFingerprint());
        params.put("manufacturer", deviceInfo.getProductManufacturer());

        params.put("mac", ConfigToolUtils.getDid());
        params.put("androidId", deviceInfo.getAndroidId());
        params.put("imeiId", deviceInfo.getImei());
        params.put("cpuId", deviceInfo.getCpuSerial());
        params.put("e_mac", NetworkManager.getInstance().getEthernetMac());
        params.put("w_mac", NetworkManager.getInstance().getWifiMac());
        params.put("b_mac", NetworkManager.getInstance().getBluetoothMac());
    }

    private void loadSdkCommonParams(){
        CommonDeviceInfo commonDeviceInfo = new CommonDeviceInfo();
        commonDeviceInfo.setFirmware(deviceInfo.getFirmware());
        commonDeviceInfo.setHost(deviceInfo.getBuildHost());
        commonDeviceInfo.setUser(deviceInfo.getBuildUser());
        commonDeviceInfo.setDevice(deviceInfo.getProductDevice());
        commonDeviceInfo.setBrand(deviceInfo.getProductBrand());
        commonDeviceInfo.setModel(deviceInfo.getProductModel());
//        commonDeviceInfo.setHardware( deviceInfo.getHardware());
//        commonDeviceInfo.setCpuHardware( deviceInfo.getCpuHardware());
        commonDeviceInfo.setSystemVersion(deviceInfo.getAndroidVersion());
        commonDeviceInfo.setSdk(deviceInfo.getSdk() + "");
        commonDeviceInfo.setDisplay(deviceInfo.getBuildDisplay());
//        commonDeviceInfo.setFingerprint( deviceInfo.getBuildFingerprint());
        commonDeviceInfo.setManufacturer(deviceInfo.getProductManufacturer());
//        commonDeviceInfo.setMac( NetworkManager.getInstance().getMac());
        commonDeviceInfo.setDid(ConfigToolUtils.getDid());
        commonDeviceInfo.setAndroidId(deviceInfo.getAndroidId());
        commonDeviceInfo.setImei(deviceInfo.getImei());
        commonDeviceInfo.setCpuSerial(deviceInfo.getCpuSerial());// 原cpuId
        commonDeviceInfo.setEthernetMac(deviceInfo.getEthernetMac());// 原e_mac
        commonDeviceInfo.setWifiMac(deviceInfo.getWifiMac());// 原w_mac
        commonDeviceInfo.setBluetoothMac(deviceInfo.getBluetoothMac());// b_mac
        params.put("deviceInfo", beanToJson(commonDeviceInfo));
    }

    protected Map<String, String> onAddParams(Request request) {
        params.put("region", GeoIPManager.getInstance().getCountryCode());
        if(mUseOldServerParams){
            params.put("language", DeviceUtils.getLocaleString());
            params.put("appVer", "" + AppUtils.getVersionCode());
        }
        return params;
    }

    protected Map<String, String> onAddHeaderParams(Request request) {
        return paramsHeader;
    }

    private static String beanToJson(Object object) {
        Gson gsontest = new Gson();
        String objStr;
        try {
            objStr = gsontest.toJson(object);
        } catch (Exception e) {
            objStr = "";
        }
        return objStr;
    }
}
