package com.cv.media.c.server;

import androidx.annotation.NonNull;

import com.cv.media.c.server.exception.ServerException;
import com.cv.media.c.server.response.ResponseStatus;
import com.google.gson.Gson;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Response;

public class ServerExceptionInterceptor implements Interceptor {
    @NonNull
    @Override
    public Response intercept(@NonNull Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());

        //可移除，baserequest中发送统一错误码

        ResponseStatus responseStatus = null;
        try {
            if (!response.isSuccessful() && response.body() != null) {
                responseStatus = new Gson().fromJson(response.body().string(), ResponseStatus.class);
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }
//
        if (responseStatus != null) {
            throw new ServerException(response.code(), responseStatus);
        }

        return response;
    }
}
