package com.cv.media.c.server.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by Joyce.Wang on 2022/02/14.
 */
public class TrailerInfo implements Parcelable {
    private String ttid;
    private int season;
    private int episode;
    private String videoName;
    private String videType;

    public TrailerInfo() {

    }

    protected TrailerInfo(Parcel in) {
        Bundle bundle = in.readBundle();
        ttid = bundle.getString("ttid");
        season = bundle.getInt("season");
        episode = bundle.getInt("episode");
        videoName = bundle.getString("videoName");
        videType = bundle.getString("VideType");
    }

    public static final Creator<TrailerInfo> CREATOR = new Creator<TrailerInfo>() {
        @Override
        public TrailerInfo createFromParcel(Parcel in) {
            return new TrailerInfo(in);
        }

        @Override
        public TrailerInfo[] newArray(int size) {
            return new TrailerInfo[size];
        }
    };

    public String getTtid() {
        return ttid;
    }

    public void setTtid(String ttid) {
        this.ttid = ttid;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }

    public String getVideoName() {
        return videoName;
    }

    public void setVideoName(String videoName) {
        this.videoName = videoName;
    }

    public String getVideType() {
        return videType;
    }

    public void setVideType(String videType) {
        this.videType = videType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle();
        bundle.putString("ttid", ttid);
        bundle.putInt("season", season);
        bundle.putInt("episode", episode);
        bundle.putString("videoName", videoName);
        bundle.putString("videType", videType);
        dest.writeBundle(bundle);
    }
}
