
package com.cv.media.c.server;

import android.text.TextUtils;

import com.cv.media.lib.hardware.device.DeviceInfo;
import com.cv.media.lib.hardware.device.HardwareManager;
import com.cv.media.lib.hardware.network.NetworkManager;

/**
 * 公共配置信息工具类
 */
public class ConfigToolUtils {

    public static String getDid() {
        String did = NetworkManager.getInstance().getMac();
        if (TextUtils.isEmpty(did) || did.equals("020000000000")) {
            // WifiInfo#getBSSID return 02:00:00:00:00:00，通过NetworkManager获取的mac就是020000000000
            // 高版本手机经测试都是返回"020000000000"，用AndroidId代替
            DeviceInfo deviceInfo = HardwareManager.getInstance().getDeviceInfo();
            if (null != deviceInfo) {

                did = deviceInfo.getAndroidId();
            }
        }
        return did;
    }
}
