
package com.cv.media.c.server.basenet;

import android.util.Log;

import com.cv.media.c.server.callback.BiFunction;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

/**
 * [请求工厂帮助类]
 *
 * @author Mac Xu
 * @Date 2023/03/22
 */
public class RequestFactoryHelper {
    private static final String TAG = RequestFactoryHelper.class.getSimpleName();

    /**
     * 添加key-value到map中
     *
     * @param requestMap   要添加的map
     * @param requestClass 要添加的请求体
     * @param eventCls     对应的请求参数
     * @param callbackCls  对应的请求回调
     */
    public static void addRequest(HashMap<String, BiFunction<BaseEvent, BaseCallback, BaseRequest>> requestMap,
                                  Class<? extends BaseRequest> requestClass,
                                  Class<? extends BaseEvent> eventCls,
                                  Class<? extends BaseCallback> callbackCls) {
        String key = getStoreKey(eventCls, callbackCls);
        requestMap.put(key, new BiFunction<BaseEvent, BaseCallback, BaseRequest>() {
            @Override
            public BaseRequest apply(BaseEvent event, BaseCallback callback) {
                BaseRequest request = null;
                try {
                    /**
                     * todo 遍历获取Constructor对象，并且获取其init中具体的参数类型做匹配，然后生成对应的request
                     * 目前写起来的比较复杂，现在暂定按照标准写
                     *
                     * 比如在各个模块的工厂中加入reqeust
                     * addRequest(QueryMyCloudsRequest.class, QueryMyCloudsEvent.class, QueryMyCloudsCallback.class);
                     * 其中QueryMyCloudsRequest的构造方法必须是QueryMyCloudsEvent和QueryMyCloudsCallback，而不能用BaseEvent和BaseCallBack
                     * 不然会发生NoSuchMethodFoundException
                     */
                    if (null == eventCls || eventCls == BaseEvent.class) { //addRequest时候没有Event可以用BaseEvent代替，或者传null
                        request = requestClass.getConstructor(callbackCls).newInstance(callback);
                    } else {
                        request = requestClass.getConstructor(eventCls, callbackCls)
                                .newInstance(event, callback);
                    }
                } catch (IllegalAccessException | InstantiationException | InvocationTargetException
                         | NoSuchMethodException e) {
                    Log.e(TAG, "add " + key + " error: " + e.getMessage());
//                    e.printStackTrace();
                }
                return request;
            }
        });
    }

    private static String getStoreKey(Class<? extends BaseEvent> event, Class<? extends BaseCallback> callback) {
        String eventKey = (null == event) ? BaseEvent.class.getName() : event.getName();
        String callbackKey = callback.getName();
        String key = String.format("%s_%s", eventKey, callbackKey);
        Log.i(TAG, "getStoreKey1: " + key);
        return String.format("%s_%s", eventKey, callbackKey);
    }

    /**
     * 获取key值
     *
     * @param event    请求参数
     * @param callback 请求回到
     * @return 返回拼接的key
     */
    public static String getStoreKey(BaseEvent event, BaseCallback callback) {
        String eventKey = (null == event) ? BaseEvent.class.getName() : event.getClass().getName();
        String callbackKey =
                (null == callback) ? BaseCallback.class.getName() : callback.getClass().getInterfaces()[0].getName();
        String key = String.format("%s_%s", eventKey, callbackKey);
        Log.i(TAG, "getStoreKey2: " + key);
        return String.format("%s_%s", eventKey, callbackKey);
    }

}
