package com.cv.media.c.server;

import com.cv.media.lib.api.okhttp.BaseParamsInterceptor;

import java.util.Map;

import okhttp3.Request;

public class ServerCommonParamsInterceptor extends BaseParamsInterceptor {
    ServerCommonParams handler;
    @Override
    protected Map<String, String> onAddParams(Request request) {
        synchronized (ServerCommonParamsInterceptor.class) {
            if(handler == null) {
                handler = Server.getCurrent().commonParamsHandler(loadOldCommonParams());
            }
        }
        return handler.onAddParams(request);
    }

    @Override
    protected Map<String, String> onAddHeaderParams(Request request) {
        synchronized (ServerCommonParamsInterceptor.class) {
            if(handler == null) {
                handler = Server.getCurrent().commonParamsHandler(loadOldCommonParams());
            }
        }
        return handler.onAddHeaderParams(request);
    }

    //todo mfc当前也是直接引用sdk paraminterceptor，但某些服务获取参数和sdk不一致，需在mfc工程中单独另建新的公共参数类
    //todo 目前时间紧张先这样sdk内部简单兼容处理。下个版本优化
    protected boolean loadOldCommonParams(){
        return false;
    }
}
