
package com.cv.media.c.server.basenet;

import com.cv.media.c.server.response.ResponseStatus;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

/**
 * [空请求体]
 *
 * @author Mac Xu
 * @Date 2023/03/21
 */
public class EmptyRequest extends BaseRequest<ResponseStatus, BaseEvent> {
    public EmptyRequest(BaseEvent event, BaseCallback<BaseEvent, ResponseStatus> callback) {
        super(event, callback);
    }

    @Override
    protected Observable<ResponseStatus> getRequest() {
        return null;
    }

    @Override
    public void request() {
        Observable.just("")
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Observer<String>() {
                    @Override
                    public void onSubscribe(Disposable d) {

                    }

                    @Override
                    public void onNext(String s) {
                        callback.onFailure(event, "", "Invalid request!");
                    }

                    @Override
                    public void onError(Throwable e) {

                    }

                    @Override
                    public void onComplete() {

                    }
                });
    }
}
