package com.cv.media.c.server.basenet;

/**
 * [网络请求返回回调基类]
 *
 * @author Mac Xu
 * @Date 2023/02/21
 */
public interface BaseCallback<E extends BaseEvent, T> {
    /**
     * 请求成功回调
     *
     * @param event 请求入参
     * @param response 返回
     */
    void onSuccess(E event, T response);

    /**
     * 请求失败回调
     *
     * @param event 请求入参
     * @param errCode 错误码
     * @param errMsg 错误信息
     */
    void onFailure(E event, String errCode, String errMsg);
}
