
package com.cv.media.c.server.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.cv.media.c.server.response.AbstractPrintable;
import com.cv.media.lib.common_utils.obfuscation.KeepClassMember;

/**
 * 详细的影片、电视剧信息
 */
public class BaseMeta extends AbstractPrintable implements KeepClassMember {
    /**
     * meta数据类型
     */
    private EVideoType metaType;

    /**
     * 以上EVideoType类型的id
     */
    private long metaId;

    /**
     * 以上EVideoType类型的标题（影片名称、播放列表名称等，也可能为空）
     */
    private String title = "";

    /**
     * 海报
     */
    private String poster = "";

    /**
     * 背景
     */
    private String backdrop = "";

    /**
     * 当前资源列表背景图
     */
    private String backgroundImage = "";

    /**
     * 评分
     */
    private double rating = 0.0D;

    /**
     * 是否有资源
     */
    private int linked = 0;

    /**
     * 发行日期
     */
    private String releaseDate;

    /**
     * 发行时间
     */
    private String firstAirDate;

    /**
     * 最后更新时间
     */
    private String LastAirDate;

    /**
     * 影片类型
     */
    private List<Genre> genres = new ArrayList();

    /**
     * 列表页面中，每个item有几种标识（评分、linked等）的展示位置（上下左右等）
     */
    private List<Tag> tags = new ArrayList();

    /**
     * 详情页，每个item有几种标识（评分、linked等）的展示位置（上下左右等）
     */
    private List<MediaTag> mediaTags = new ArrayList<>();

    /**
     * 扩展字段
     */
    private Map<String, String> extra = new HashMap();

    /**
     * 影片情节
     */
    private String plot;

    /**
     * 影片观看数，格式化的字符串
     */
    private String viewedFormat;

    /**
     * 3.0版本新增，列表类型
     */
    private EPlaylistType listType;

    /**
     * 3.0版本新增展示类型，值为extra属性中displayType
     */
    private String displayType;

    /**
     * 校验和（用于后台判断缓存有没有过期）
     */
    private String checksum;

    /**
     * 2.3.0 版本新增布局格式属性
     */
    private String layout;

    /**
     * 2.3版本新增（影片或剧集在各个国家的评级）
     */
    private List<Certificate> certificates = new ArrayList<>();

    public EVideoType getMetaType() {
        return metaType;
    }

    public void setMetaType(EVideoType metaType) {
        this.metaType = metaType;
    }

    public long getMetaId() {
        return metaId;
    }

    public void setMetaId(long metaId) {
        this.metaId = metaId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPoster() {
        return poster;
    }

    public void setPoster(String poster) {
        this.poster = poster;
    }

    public String getBackdrop() {
        return backdrop;
    }

    public void setBackdrop(String backdrop) {
        this.backdrop = backdrop;
    }

    public String getBackgroundImage() {
        return backgroundImage;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public double getRating() {
        return rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public int getLinked() {
        return linked;
    }

    public void setLinked(int linked) {
        this.linked = linked;
    }

    public String getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getFirstAirDate() {
        return firstAirDate;
    }

    public void setFirstAirDate(String firstAirDate) {
        this.firstAirDate = firstAirDate;
    }

    public String getLastAirDate() {
        return LastAirDate;
    }

    public void setLastAirDate(String lastAirDate) {
        LastAirDate = lastAirDate;
    }

    public List<Genre> getGenres() {
        return genres;
    }

    public void setGenres(List<Genre> genres) {
        this.genres = genres;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<MediaTag> getMediaTags() {
        return mediaTags;
    }

    public void setMediaTags(List<MediaTag> mediaTags) {
        this.mediaTags = mediaTags;
    }

    public Map<String, String> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }

    public String getPlot() {
        return plot;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    public String getViewedFormat() {
        return viewedFormat;
    }

    public void setViewedFormat(String viewedFormat) {
        this.viewedFormat = viewedFormat;
    }

    public EPlaylistType getListType() {
        return listType;
    }

    public void setListType(EPlaylistType listType) {
        this.listType = listType;
    }

    public String getDisplayType() {
        return displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public String getChecksum() {
        return checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getLayout() {
        return layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public List<Certificate> getCertificates() {
        return certificates;
    }

    public void setCertificates(List<Certificate> certificates) {
        this.certificates = certificates;
    }
}
