package com.cv.media.c.server.model;

import java.io.Serializable;

/**
 * 登录返回的子账号信息 (ActualType: SubAccountDto)
 */
public class SubAccount implements Serializable {
    /**
     * uid
     */
    private Long uid;

    /**
     * 子账号ID
     */
    private Long subAccountId;

    /**
     * 是否为master，是否是主账号
     */
    private boolean master;

    /**
     * 子账号名
     */
    private String subAccountName;

    /**
     * did
     */
    private String did;

    /**
     * 排序号
     */
    private Long sortNo;

    /**
     * icon id
     */
    private Long iconId;

    /**
     * 状态
     */
    private Integer status;

    public SubAccount() {
    }

    public SubAccount(Long subAccountId, String subAccountName) {
        this.subAccountId = subAccountId;
        this.subAccountName = subAccountName;
    }

    public SubAccount(Long subAccountId, Long avatarId, String subAccountName) {
        this.subAccountId = subAccountId;
        this.iconId = avatarId;
        this.subAccountName = subAccountName;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getSubAccountId() {
        return this.subAccountId;
    }

    public void setSubAccountId(Long subAccountId) {
        this.subAccountId = subAccountId;
    }

    public String getSubAccountName() {
        return this.subAccountName;
    }

    public void setSubAccountName(String subAccountName) {
        this.subAccountName = subAccountName;
    }

    public String getDid() {
        return this.did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public Long getSortNo() {
        return this.sortNo;
    }

    public void setSortNo(Long sortNo) {
        this.sortNo = sortNo;
    }

    public Long getIconId() {
        return iconId;
    }

    public void setIconId(Long iconId) {
        this.iconId = iconId;
    }
}
