package com.cv.media.c.server.callback;


import java.util.Objects;

/**
 * 拷贝java.util.function.Consumer
 * sdk低版本可用，用于提供内部使用的一些函数式调用
 *
 * @param <T>
 */
@FunctionalInterface
public interface Consumer<T> {
    void accept(T t);

    default Consumer<T> andThen(Consumer<? super T> after) {
        Objects.requireNonNull(after);
        return (T t) -> {
            accept(t);
            after.accept(t);
        };
    }
}
