package com.cv.media.c.server;

import android.text.TextUtils;

import com.cv.media.lib.api.okhttp.BaseCryptoInterceptor;
import com.cv.media.lib.common_utils.crypto.SecurityUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

/**
请求 加密解密 步骤
@Author Damon
*/
public class ServerCryptoInterceptor extends BaseCryptoInterceptor {
    private Gson gson;
    private java.lang.reflect.Type type;

    private static final String KEY_CRYPT_VERSION = "5";

    public ServerCryptoInterceptor() {
        gson = new GsonBuilder().serializeNulls()
                .setDateFormat("yyyy-MM-dd HH:mm:ss").create();
        type = new TypeToken<Map<String, String>>() {
        }.getType();
    }


    protected boolean onEncrypt(Request request) {
        return !TextUtils.equals(request.method(), "POST") && isCipherRequest(request);
    }

    protected final Request getCipherRequest(Request request) {
        HttpUrl httpUrl = request.url();
        Map<String, String> params = new HashMap<>(20);
        for (int i = 0; i < httpUrl.querySize(); i++) {
            params.put(httpUrl.queryParameterName(i), httpUrl.queryParameterValue(i));
        }

        String reqM;
        String reqS;
        try {
            reqM = SecurityUtil.getInstance().encryptString(gson.toJson(params));
            reqS = SecurityUtil.getInstance().sign(reqM);
        } catch (Exception e) {
            reqM = "";
            reqS = "";
        }

        String newUrl = new StringBuilder().append(httpUrl.scheme()).append("://").append(httpUrl.host()).append(":").append(httpUrl.port()).append(httpUrl.encodedPath()).toString();
        Request newRequest;
        RequestBody requestBody = new FormBody.Builder()
                .add("v", KEY_CRYPT_VERSION)
                .add("m", reqM)
                .add("s", reqS)
                .build();
        newRequest = request.newBuilder().url(newUrl).post(requestBody).build();
        return newRequest;
    }

    @Override
    protected final Response getDecryptResponse(Response response) {
        try {
            if (!isCipherResponse(response.request())) {
                return response;
            }
            ResponseBody responseBody = response.body();
            //响应状态码 200~300 || 555  ----> 对响应体解密
            String resStr = responseBody.string();
            try{
                Map<String, String> resData = gson.fromJson(resStr, type);
                String resM;
                if (!TextUtils.equals(resData.get("v"), "0")) { // 响应加密
                    resM = SecurityUtil.getInstance().decryptString(resData.get("m"));
                } else { // 响应未加密
                    resM = resData.get("m"); // 响应未加密
                }
                ResponseBody newResponseBody = ResponseBody.create(responseBody.contentType(), resM);
                return response.newBuilder().body(newResponseBody).build();
            }catch (Exception e){
                //返回明文，或者抓包工具解密处理后
                ResponseBody newResponseBody = ResponseBody.create(responseBody.contentType(), resStr);
                return response.newBuilder().body(newResponseBody).build();
            }

        } catch (Exception e) {
            e.printStackTrace();
            return response;
        }
    }

    //对于字幕的下载，需要走解密流程，会对字幕再次进行utf-8编码导致字幕有乱码
    private boolean isCipherResponse(Request request) {
        String requestPath = request.url().encodedPath();
        return !StringUtils.contains(requestPath, "/api/st/get/v2");
    }

    private boolean isCipherRequest(Request request) {
        String requestPath = request.url().encodedPath();
        return !(StringUtils.contains(requestPath, "/api/st/adjust/v1") ||
                StringUtils.contains(requestPath, "/api/st/afferent/v1"));
    }
}
