package com.cv.media.c.server;

import com.cv.media.lib.api.okhttp.BaseParamsInterceptor;

import java.util.Map;

import okhttp3.Request;

public class ServerCommonParamsInterceptor extends BaseParamsInterceptor {
    ServerCommonParams handler;
    @Override
    protected Map<String, String> onAddParams(Request request) {
        synchronized (ServerCommonParamsInterceptor.class) {
            if(handler == null) {
                handler = Server.getCurrent().commonParamsHandler();
            }
        }
        return handler.onAddParams(request);
    }

    @Override
    protected Map<String, String> onAddHeaderParams(Request request) {
        synchronized (ServerCommonParamsInterceptor.class) {
            if(handler == null) {
                handler = Server.getCurrent().commonParamsHandler();
            }
        }
        return handler.onAddHeaderParams(request);
    }
}
