package com.cv.media.c.server;

import androidx.annotation.NonNull;

import com.cv.media.c.server.exception.ServerException;
import com.cv.media.c.server.response.ResponseStatus;
import com.google.gson.Gson;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Response;

public class ServerExceptionInterceptor implements Interceptor {
    @NonNull
    @Override
    public Response intercept(@NonNull Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        ResponseStatus responseStatus = null;
        try {
            if (response.code() == 555 && response.body() != null) {
                responseStatus = new Gson().fromJson(response.body().string(), ResponseStatus.class);
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }

        if (responseStatus != null) {
            SGSEManager.getInstance().handleResponse(responseStatus);
            throw new ServerException(responseStatus);
        }

        return response;
    }
}
