package com.cv.media.c.server;

import com.cv.media.lib.common_utils.callback.ICallBack;

import java.util.Map;

import okhttp3.Request;

public abstract class BaseServer implements IServer {
    ICallBack<Map<String, String>> extraParamsCb;
    ICallBack<Map<String, String>> extraHeaderParamsCb;
    @Override
    public final ServerCommonParams commonParamsHandler() {
        return new ServerCommonParams() {
            @Override
            protected Map<String, String> onAddParams(Request request) {
                Map<String, String> maps = super.onAddParams(request);
                BaseServer.this.onAddParams(request, maps);
                if (extraParamsCb != null) extraParamsCb.call(maps);
                return maps;
            }

            @Override
            protected Map<String, String> onAddHeaderParams(Request request) {
                Map<String, String> maps = super.onAddHeaderParams(request);
                BaseServer.this.onAddHeaderParams(request, maps);
                if (extraHeaderParamsCb != null) extraHeaderParamsCb.call(maps);
                return maps;
            }
        };
    }

    protected abstract void onAddParams(Request request, Map<String, String> map);
    protected abstract void onAddHeaderParams(Request request, Map<String, String> map);

    public final void setExtraParamsCb(ICallBack<Map<String, String>> extraParamsCb) {
        this.extraParamsCb = extraParamsCb;
    }

    public final void setExtraHeaderParamsCb(ICallBack<Map<String, String>> extraHeaderParamsCb) {
        this.extraHeaderParamsCb = extraHeaderParamsCb;
    }
}
