package com.cv.media.c.server;

import android.content.Context;

import com.cv.media.lib.common_utils.utils.AppUtils;
import com.cv.media.lib.common_utils.utils.DeviceUtils;
import com.cv.media.lib.common_utils.utils.JsonUtil;

import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import okhttp3.Request;

/**
 * MFC平台 公共参数差异化体现
 * 职责:
 *
 * @author Damon
 */
class MFCServer extends BaseServer {
    @Override
    protected void onAddParams(Request request, Map<String, String> map) {
        map.put("appId", "mfc-stb");
        map.put("vnoId", "vod");
        map.put("productId", "mfc");
        map.put("channelId", AppUtils.getApkChannel());
        map.put("channelDeviceType", getChannelDeviceType());
        map.put("preVendorId", DeviceUtils.getPreVendorId());
    }

    @Override
    protected void onAddHeaderParams(Request request, Map<String, String> map) {

    }

    ///////////////////////Zeasn////////////////////    ///////////////////////Zeasn////////////////////
    ///////////////////////Zeasn////////////////////    ///////////////////////Zeasn////////////////////
    ///////////////////////Zeasn////////////////////    ///////////////////////Zeasn////////////////////
    ///////////////////////Zeasn////////////////////    ///////////////////////Zeasn////////////////////
    ///////////////////////Zeasn////////////////////    ///////////////////////Zeasn////////////////////
    static final String[] propsKey = new String[]{
            "persist.sys.push",
            "ro.product.devicetype",
            "ro.kitking.devicetype",
            "ro.kontech.devicetype",
            "ro.zeasn.devicetype",
            "ro.selenview.devicetype",
            "ro.product.model",
            "mstar.zvt.devicetype",
            "ro.product.device",
            "ro.skyworth.devicetype",
            "ro.changhong.model",
            "ro.build.firmwaretag",
            "ro.haier.devicetype",
            "ro.kdp.devicetype",
            "ro.kdp.devicetypekid",
            "ro.tcl.client.type",
            "ro.nextgenpro.devicetype",
            "zeasnpublicdefalt",
            "TCLSCBCAndroidMsd338default",
            "ro.devicetype.zeasn",
    };

    private static Method getProp;
    private static Class systemProps;

    private static String getSystemProp(String key) {
        if (getProp == null) {
            try {
                systemProps = Context.class.getClassLoader().loadClass("android.os.SystemProperties");
                getProp = systemProps.getDeclaredMethod("get", String.class, String.class);
                getProp.setAccessible(true);
            } catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        try {
            return (String) getProp.invoke(systemProps, key, "");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String getChannelDeviceType() {
        HashMap<String, String> map = new HashMap<>();
        for (String key : propsKey) {
            String value = getSystemProp(key);
            if (!StringUtils.isEmpty(value)) map.put(key, value);
        }
        return JsonUtil.parseMapToJson(map);
    }

    ///////////////////////////////////////////    ///////////////////////////////////////////
    ///////////////////////////////////////////    ///////////////////////////////////////////
    ///////////////////////////////////////////    ///////////////////////////////////////////
    ///////////////////////////////////////////    ///////////////////////////////////////////
    ///////////////////////////////////////////    ///////////////////////////////////////////
}
