package com.cv.media.c.server.model;

import java.io.Serializable;

public enum EVideoType implements Serializable {
    UNKNOWN,
    PLAYLIST,
    SEARCH_LIST,
    MOVIE,
    SERIES,
    SEASON,
    EPISODE,
    DOCUMENTARY,
    SHORT,
    VIDEO,
    TV_SPECIAL,
    PERSON,
    ADULT,
    VIDOE_TYPE_END;

    private EVideoType() {
    }

    public static EVideoType valueOf(int videoTypeInt) {
        switch (videoTypeInt) {
            case 1:
                return PLAYLIST;
            case 2:
                return SEARCH_LIST;
            case 3:
                return MOVIE;
            case 4:
                return SERIES;
            case 5:
                return SEASON;
            case 6:
                return EPISODE;
            case 7:
                return DOCUMENTARY;
            case 8:
                return SHORT;
            case 9:
                return VIDEO;
            case 10:
                return TV_SPECIAL;
            default:
                return UNKNOWN;
        }
    }
}
