package com.cv.media.c.server.response;

import com.cv.media.lib.common_utils.obfuscation.KeepClassMember;

import java.util.List;

/**
 * Created by richu on 2015/10/6.
 */
public class ResponseDataList<T> extends ResponseMsgList<T> implements KeepClassMember {
    public ResponseDataList(int retCode, int status, String message) {
        super();
        setStatus(retCode, status, message);
    }

    public ResponseDataList(ResponseDataSingle responseDataSingle) {
        this.setCount(responseDataSingle.getCount());
        this.setPageId(responseDataSingle.getPageId());
        this.setPageNo(responseDataSingle.getPageNo());
        this.setPageSize(responseDataSingle.getPageSize());
        //this.results.add(responseDataSingle.getResult());
        this.setQueryDuration(responseDataSingle.getQueryDuration());
        this.setQueryTime(responseDataSingle.getQueryTime());
        this.setStatus(responseDataSingle.getRetCode(), responseDataSingle.getErrCode(), responseDataSingle.getMessage());
        this.setTotalCount(responseDataSingle.getTotalCount());
    }

    public int getCount() {
        return count;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public boolean isDefaultList() {
        return isDefaultList;
    }

    public int getPageNo() {
        return pageNo;
    }

    public long getQueryDuration() {
        return queryDuration;
    }

    public long getQueryTime() {
        return queryTime;
    }

    public List<T> getResults() {
        return result;
    }
}
