package com.cv.media.c.server;

import android.util.Log;

import com.cv.media.lib.common_utils.callback.ICallBack;

import java.util.Map;

/**
* c_server中业务平台的异化配置接口类
* 职责:
* @author Damon
*/
public class Server {
    private static final String TAG = "VOD_SDK Server";

    private static IServer server;

    public static void init(IServer iServer){
        Log.i(TAG, "init");
        server = iServer;
    }

    public static void init(CVServer serverType) {
        server = serverType.server();
    }
    
    public static void init(CVServer serverType, ICallBack<Map<String, String>> extraParamsCb, ICallBack<Map<String, String>> extraHeaderParamsCb) {
        server = serverType.server();
        ((BaseServer)server).setExtraParamsCb(extraParamsCb);
        ((BaseServer)server).setExtraHeaderParamsCb(extraHeaderParamsCb);
    }
    
    static IServer getCurrent() {
        if(server == null) throw new RuntimeException("Server must init");
        return server;    
    }
}
