package com.cv.media.c.server.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

import com.cv.media.lib.common_utils.obfuscation.KeepAll;

import java.util.ArrayList;

public class CloudPlaySource implements Parcelable, KeepAll {
    private long cid = 0L;
    private String site = "";
    private String acct = "";
    private String acctAlias = "";
    private String resName = "";
    private String resId = "";
    private String resKey = "";
    private long resLength = 0L;
    private long priority = 0L;
    private String format = "";
    private String quality = "";
    private String extra = "";
    protected long createTS;
    protected long updateTS;
    private String loginType = "";
    private String acctKey = "";
    private String streamToken = "";
    private ArrayList<String> videoLangs = new ArrayList();
    private String resolution = "";

    public CloudPlaySource() {
    }

    protected CloudPlaySource(Parcel in) {
        Bundle bundle = in.readBundle();
        cid = bundle.getLong("Cid");
        site = bundle.getString("Site");
        acct = bundle.getString("Acct");
        acctAlias = bundle.getString("AcctAlias");
        resName = bundle.getString("ResName");
        resId = bundle.getString("ResId");
        resKey = bundle.getString("ResKey");
        resLength = bundle.getLong("ResLength");
        priority = bundle.getLong("Priority");
        format = bundle.getString("Format");
        quality = bundle.getString("Quality");
        extra = bundle.getString("Extra");
        createTS = bundle.getLong("CreateTS");
        updateTS = bundle.getLong("UpdateTS");
        loginType = bundle.getString("LoginType");
        acctKey = bundle.getString("AcctKey");
        streamToken = bundle.getString("StreamToken");
        videoLangs = bundle.getStringArrayList("VideoLangs");
        resolution = bundle.getString("Resolution");
    }

    public static final Creator<CloudPlaySource> CREATOR = new Creator<CloudPlaySource>() {
        @Override
        public CloudPlaySource createFromParcel(Parcel in) {
            return new CloudPlaySource(in);
        }

        @Override
        public CloudPlaySource[] newArray(int size) {
            return new CloudPlaySource[size];
        }
    };

    public long getCid() {
        return this.cid;
    }

    public void setCid(long cid) {
        this.cid = cid;
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getAcct() {
        return this.acct;
    }

    public void setAcct(String acct) {
        this.acct = acct;
    }

    public String getAcctAlias() {
        return this.acctAlias;
    }

    public void setAcctAlias(String acctAlias) {
        this.acctAlias = acctAlias;
    }

    public String getResName() {
        return this.resName;
    }

    public void setResName(String resName) {
        this.resName = resName;
    }

    public String getResId() {
        return this.resId;
    }

    public void setResId(String resId) {
        this.resId = resId;
    }

    public String getResKey() {
        return this.resKey;
    }

    public void setResKey(String resKey) {
        this.resKey = resKey;
    }

    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) {
        this.priority = priority;
    }

    public long getResLength() {
        return this.resLength;
    }

    public void setResLength(long resLength) {
        this.resLength = resLength;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public long getCreateTS() {
        return this.createTS;
    }

    public void setCreateTS(long createTS) {
        this.createTS = createTS;
    }

    public long getUpdateTS() {
        return this.updateTS;
    }

    public void setUpdateTS(long updateTS) {
        this.updateTS = updateTS;
    }

    public String getLoginType() {
        return this.loginType;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public String getAcctKey() {
        return this.acctKey;
    }

    public void setAcctKey(String acctKey) {
        this.acctKey = acctKey;
    }

    public String getStreamToken() {
        return this.streamToken;
    }

    public void setStreamToken(String streamToken) {
        this.streamToken = streamToken;
    }

    public ArrayList<String> getVideoLangs() {
        return this.videoLangs;
    }

    public void setVideoLangs(ArrayList<String> videoLangs) {
        this.videoLangs = videoLangs;
    }

    public String getResolution() {
        return resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle();
        bundle.putLong("Cid", cid);
        bundle.putString("Site", site);
        bundle.putString("Acct", acct);
        bundle.putString("AcctAlias", acctAlias);
        bundle.putString("ResName", resName);
        bundle.putString("ResId", resId);
        bundle.putString("ResKey", resKey);
        bundle.putLong("ResLength", resLength);
        bundle.putLong("Priority", priority);
        bundle.putString("Format", format);
        bundle.putString("Quality", quality);
        bundle.putString("Extra", extra);
        bundle.putLong("CreateTS", createTS);
        bundle.putLong("UpdateTS", updateTS);
        bundle.putString("LoginType", loginType);
        bundle.putString("AcctKey", acctKey);
        bundle.putString("StreamToken", streamToken);
        bundle.putStringArrayList("VideoLangs", videoLangs);
        bundle.putString("Resolution", resolution);
        dest.writeBundle(bundle);
    }
}
