package com.cv.media.c.server;

import com.cv.media.c.server.response.ResponseStatus;
import com.cv.media.lib.common_utils.rxjava.StreamController;
import com.cv.media.lib.common_utils.utils.Singleton;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;

/**
 * Special Global Server Exception
 * 职责:  发现 所有模块的业务请求都会出现的 特殊异常, 并 通知外界
 *
 * @author Damon
 */
public class SGSEManager {
    private static Singleton<SGSEManager> singleton = new Singleton<SGSEManager>() {
        @Override
        protected SGSEManager create() {
            return new SGSEManager();
        }
    };

    public static SGSEManager getInstance() {
        return singleton.get();
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    final HashMap<String, StreamController<Object>> errorCodeToSc = new HashMap<>();

    public SGSEManager() {
    }

    void handleResponse(ResponseStatus responseStatus) {
        if (responseStatus == null) return;
        StreamController<Object> sc = errorCodeToSc.get(errorCodeStr(responseStatus));
        if (sc != null) sc.push(new Object());
    }

    private String errorCodeStr(ResponseStatus responseStatus) {
        return responseStatus.getRetCode() + "-" + responseStatus.getErrCode();
    }

    public Observable<Object> onEvent(SGSEEvent event, int retCode, int errorCode) {
        errorCodeToSc.put("" + retCode + "-" + errorCode, event.sc);
        return event.sc.stream().throttleFirst(2, TimeUnit.SECONDS, Schedulers.single());
    }

    public void tear(SGSEEvent event) {
        event.sc.push(new Object());
        event.sc.push(new Object());
        event.sc.push(new Object());
        event.sc.push(new Object());
        event.sc.push(new Object());
    }
}
