package com.cv.media.c.server;

import com.cv.media.lib.common_utils.utils.DeviceUtils;
import com.cv.media.lib.geoip.manager.GeoIPManager;
import com.cv.media.lib.hardware.device.DeviceInfo;
import com.cv.media.lib.hardware.device.HardwareManager;
import com.cv.media.lib.hardware.network.NetworkManager;

import java.util.HashMap;
import java.util.Map;

import okhttp3.Request;

/**
 * 所有平台共同的公共参数
 * 职责:
 *
 * @author Damon
 */
class ServerCommonParams {
    protected HashMap<String, String> params;
    protected HashMap<String, String> paramsHeader;
    protected DeviceInfo deviceInfo;

    {
        params = new HashMap<>();
        paramsHeader = new HashMap<>();
        deviceInfo = HardwareManager.getInstance().getDeviceInfo();
        params.put("firmware", deviceInfo.getFirmware());
        params.put("host", deviceInfo.getBuildHost());
        params.put("user", deviceInfo.getBuildUser());
        params.put("device", deviceInfo.getProductDevice());
        params.put("brand", deviceInfo.getProductBrand());
        params.put("model", deviceInfo.getProductModel());
        params.put("hardware", deviceInfo.getHardware());
        params.put("cpuHardware", deviceInfo.getCpuHardware());
        params.put("systemVersion", deviceInfo.getAndroidVersion());
        params.put("sdk", deviceInfo.getSdk() + "");
        params.put("display", deviceInfo.getBuildDisplay());
        params.put("fingerprint", deviceInfo.getBuildFingerprint());
        params.put("manufacturer", deviceInfo.getProductManufacturer());

        params.put("mac", NetworkManager.getInstance().getMac());
        params.put("androidId", deviceInfo.getAndroidId());
        params.put("imeiId", deviceInfo.getImei());
        params.put("cpuId", deviceInfo.getCpuSerial());
        params.put("e_mac", deviceInfo.getEthernetMac());
        params.put("w_mac", deviceInfo.getWifiMac());
        params.put("b_mac", deviceInfo.getBluetoothMac());
//        params.put("language", DeviceUtils.getLocaleString());
//        params.put("appVer", "" + AppUtils.getVersionCode());

        if (BuildConfig.DEBUG) {
            params.put("isDebug", "true");
        }
    }

    protected Map<String, String> onAddParams(Request request) {
        params.put("region", GeoIPManager.getInstance().getCountryCode());
        params.put("language", DeviceUtils.getLocaleString());
        params.put("appVer", "" + VersionCodeHelper.getversionCode());
        return params;
    }

    protected Map<String, String> onAddHeaderParams(Request request) {
        return paramsHeader;
    }
}
