package com.cv.media.aar;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;

import com.vod.android.arouter.core.IARouterInitApplication;
import com.vod.android.arouter.launcher.ARouter;
import com.cv.media.c.config.appconfig.AppConfig;
import com.cv.media.c.config.appconfig.AppConfigManager;
import com.cv.media.c.config.datastatus.AutherConfig;
import com.cv.media.c.config.profile.ProfileConfig;
import com.cv.media.c.interfaces.service.account.IAccountInfo;
import com.cv.media.c.interfaces.service.account.IAccountModuleService;
import com.cv.media.c.interfaces.service.account.IAccountSerivce;
import com.cv.media.c.interfaces.service.feedback.IFeedBackModuleService;
import com.cv.media.c.interfaces.service.firebase.IFirebaseModuleService;
import com.cv.media.c.interfaces.service.home.IHomeModuleService;
import com.cv.media.c.interfaces.service.live.ILiveModuleService;
import com.cv.media.c.interfaces.service.message.IMessageModuleService;
import com.cv.media.c.interfaces.service.netdisk.INetDiskModuleService;
import com.cv.media.c.interfaces.service.notify.INotifyModuleService;
import com.cv.media.c.interfaces.service.ota.IOtaModuleService;
import com.cv.media.c.interfaces.service.play.IPlayModuleService;
import com.cv.media.c.interfaces.service.profile.IProfileModuleService;
import com.cv.media.c.interfaces.service.settings.ISettingsModuleService;
import com.cv.media.c.interfaces.service.vod.IMetaModuleService;
import com.cv.media.c.server.model.HostKey;
import com.cv.media.c.tracking.LaunchProtocol;
import com.cv.media.c.tracking.MfcTracking;
import com.cv.media.c.tracking.PageBrowseInfoCollector;
import com.cv.media.c.tracking.events.TrackingEvent_UserUseApp_Start;
import com.cv.media.c.tracking.events.TrackingEvent_UserUseApp_Stop;
import com.cv.media.lib.api.dns.RdnsController;
import com.cv.media.lib.common_utils.appinit.ITask;
import com.cv.media.lib.common_utils.appinit.Initialization;
import com.cv.media.lib.common_utils.appinit.InitializationTaskFactory;
import com.cv.media.lib.common_utils.appstat.AppManager;
import com.cv.media.lib.common_utils.appstat.features.IAppFeatures;
import com.cv.media.lib.common_utils.laucher.DataFromLaunch;
import com.cv.media.lib.common_utils.ntp.TrueTime;
import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.cv.media.lib.common_utils.utils.AppUtils;
import com.cv.media.lib.common_utils.utils.DeviceUtils;
import com.cv.media.lib.common_utils.utils.GsonUtil;
import com.cv.media.lib.common_utils.utils.MD5Utils;
import com.cv.media.lib.common_utils.utils.UiUtils;
import com.cv.media.lib.common_utils.utils.storage.DirectoryUtils;
import com.cv.media.lib.geoip.manager.GeoIPManager;
import com.cv.media.lib.geoip.model.GeoIP;
import com.cv.media.lib.hardware.device.DeviceInfo;
import com.cv.media.lib.hardware.device.HardwareManager;
import com.cv.media.lib.hardware.network.NetworkManager;
import com.cv.media.lib.log.Logger;
import com.cv.media.lib.metric.data.MetricData;
import com.cv.media.lib.metric.devmetric.MetricAgentManager;
import com.cv.media.lib.metric.manager.MetricManager;
import com.cv.media.lib.mvx.base.BaseApplication;
import com.cv.media.lib.mvx.compArch.HostApplication;
import com.cv.media.lib.tracker.TrackingService;
import com.cv.media.lib.ui.progressview.ProgressManager;
import com.cv.media.lib.ui.toast.ToastUtils;
import com.cv.media.m.external.VodSdkManager;
import com.cv.mobile.c.ui.BuildConfig;
import com.cv.mobile.c.ui.glide.ImagePathCompletion;
import com.cv.mobile.c.ui.utils.DensityUtil;
import com.cv.mobile.m.play.utils.HostUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import io.reactivex.disposables.Disposable;
import me.jessyan.autosize.AutoSizeConfig;
import me.jessyan.autosize.onAdaptListener;
import me.jessyan.autosize.utils.ScreenUtils;

public class GeneralApplication extends HostApplication implements IARouterInitApplication, Initialization.InitializationListener {
    AppBridgeImpl mAppBridge = new AppBridgeImpl();
    Application originApp;
    private static final String TAG = BaseApplication.class.getSimpleName();
    String sessionId;
    Runnable initCb;
    VodConfiguration configuration;

    public static boolean isLocalRequest = false;

    protected void updateSessionId() {
        sessionId = MD5Utils.MD5(System.currentTimeMillis() + "");
    }

    public AppBridge getAppBridge() {
        return mAppBridge;
    }

    @Override
    public void onCreate() {
        initDensityUtil();
        isLocalRequest = "mfc-mobile".equals(configuration.releaseId());
        initHost();

        MetricManager.init(this, BuildConfig.APP_ID, BuildConfig.METRIC_HOST, null, BuildConfig.FLAVOR_platform + "_");
        TrackingService.setWorkingTrackingAPI(MfcTracking.class);
        ProgressManager.initLoadingDialogStyle(R.style.CUILoadingDialogStyle, R.drawable.c_ui_progress_loading_circle_draw, UiUtils.getDimensionPixelSize(this, R.dimen.c_ui_font_size_28px));
        updateSessionId();
        Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
        initAutoSizeConfig();
        registerActivityLifecycleCallbacks(PageBrowseInfoCollector.getInstance());
        Initialization.getInstance().addListener(this);
        Initialization.getInstance().attachNetWorkObservable(new NetWorkObservable());
        Disposable ignore = AppManager.INSTANCE.getApp().appStatChanged().subscribe(appStat -> {
            onForeground(appStat == IAppFeatures.AppStat.Foreground);
        });
        DataFromLaunch.getInstance().reg(LaunchProtocol.KEY_FROM_APP_ID);
        DirectoryUtils.init(BuildConfig.APP_ID);

        Initialization.getInstance().addTask(InitializationTaskFactory.obtainNormalTask().withExecution(new Runnable() {
            @Override
            public void run() {
                HashMap<String, String> tagMap = new HashMap<>();
                try {
                    tagMap.put("localPostTime", String.valueOf(TrueTime.getInstance().currentTimeMillis()));
                    tagMap.put("language", DeviceUtils.getLocaleString());
                    tagMap.put("appVer", String.valueOf(AppUtils.getVersionCode()));
                    tagMap.putAll(GsonUtil.getGson().fromJson(GsonUtil.getGson().toJson(HardwareManager.getInstance().getDeviceInfo()), HashMap.class));
                } catch (Exception e) {
                    e.printStackTrace();
                }

                MetricAgentManager.init(tagMap, BuildConfig.METRICAGENT_APPID, BuildConfig.METRICAGENT_APPKEY, BuildConfig.METRICAGENT_HOST);
            }
        }).withInitClass(MetricAgentManager.class).withThread());

        Initialization.getInstance().addTask(InitializationTaskFactory.obtainNormalTask().withInitClass(RdnsController.class).withExecution(() -> {
            //live init即可，vod无需init
            if (isLocalRequest) {
                RdnsController.getInstance().init(GeneralApplication.this
                        , DirectoryUtils.getRdnsWorkDir(GeneralApplication.this), BuildConfig.RDNS_SERVERS);
            }
        }).withThread());

        initConfig();

        super.onCreate();

        ARouter.getInstance().navigation(IAccountSerivce.class).registerVodApplicationListener(resetHost -> {
            if (resetHost) {
                HashMap<HostKey, String> toHostKey = toHostKey(configuration);
                if(TextUtils.isEmpty(toHostKey.get(HostKey.HOST_ACCOUNT))){
                    ToastUtils.showToast(GeneralApplication.this,R.string.account_service_unavailable_invalid_url);
                }

                VodSdkManager.getInstance().resetHost(toHostKey);
            }
        });

        //埋点公共参数配置
        {
            WindowManager windowManager = (WindowManager) getSystemService(Context.WINDOW_SERVICE);
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
            MetricManager.getInstance().addMetricChain(data -> {
                MetricData.Builder builder = data.newBuilder();
                IAccountInfo accountInfo = ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo();
                //保留属性
                {
                    if (accountInfo != null && accountInfo.isLogined()) {
                        builder.put("uid", accountInfo.getUid() + "" + accountInfo.getAccountType());
                        builder.put("account_id", accountInfo.getUid());
                        //0-device，2-account card，4-code（对于LIVE，输入code也会创建一个账号），1-email，3-phone
                        builder.put("login_type", accountInfo.getLoginType());
                        builder.put("account_name", accountInfo.getAccountName());
                        builder.put("is_expired", accountInfo.isExpired() ? 1 : 0);
                        builder.put("valid_date", accountInfo.expireTs());
                        builder.put("user_status", 0);
                        builder.put("vendor_id", accountInfo.getVendorId());
                    }

                    builder.put("action_time", TrueTime.getInstance().currentTimeMillis());
                    builder.put("session_id", sessionId);
                    builder.put("page_path", PageBrowseInfoCollector.getInstance().getPagePath());
                }

                //应用相关
                {
                    builder.put("release_id", configuration.releaseId());
                    builder.put("source_id", getString(R.string.vod_mobile_sourceid));
                    builder.put("account_source", getString(R.string.vod_mobile_brand));
                    try {
                        if (accountInfo != null)
                            builder.put("vendor_id", accountInfo.getVendorId());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    builder.put("app_name", getResources().getString(getApplicationInfo().labelRes));
                    builder.put("ver_code", AppUtils.getVersionCode());
                    builder.put("basever_code", null);
                    builder.put("brand_id", getString(R.string.vod_mobile_brand));
                    builder.put("product_id", null);
                    builder.put("vno_id", getString(R.string.vod_mobile_vno));
                }

                //设备相关
                {
                    builder.put("mac", NetworkManager.getInstance().getMac());
                    builder.put("terminal_type", "mobile");
                    builder.put("manufacturer", Build.MANUFACTURER);
                    builder.put("brand", Build.BRAND);
                    builder.put("model", Build.MODEL);
                    builder.put("os", "Android");
                    builder.put("android_version", Build.VERSION.RELEASE);
                    builder.put("sdk", Build.VERSION.SDK_INT);
                    builder.put("screen_width", displayMetrics.widthPixels);
                    builder.put("screen_height", displayMetrics.heightPixels);
                    builder.put("net_state", NetworkManager.getInstance().isEthernetConnected() ? "ethernet" : (NetworkManager.getInstance().isWifiConnected() ? "wifi" : null));
                    builder.put("browser", null);
                    builder.put("browser_version", null);
                    builder.put("carrier", null);
                    builder.put("system_language", DeviceUtils.getLocaleString());
                }

                //地理位置
                {
                    GeoIP geoIP = GeoIPManager.getInstance().getGeoIP();
                    if (geoIP != null) {
                        builder.put("timezone", geoIP.getTimeZone());
                        builder.put("ip", geoIP.getIp());
                        builder.put("country", geoIP.getCountryName());
                        builder.put("city", geoIP.getCity());
                        builder.put("province", geoIP.getRegionName());
                    }
                }
                return builder.build();
            }).addMetricChain(MetricManager.MetricKey.SLA, data -> {
                MetricData.Builder builder = data.newBuilder();

                IAccountInfo accountInfo = ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo();
                //保留属性
                {
                    if (accountInfo != null && accountInfo.isLogined()) {
                        builder.put("uid", accountInfo.getUid() + "" + accountInfo.getAccountType());
                        builder.put("accountId", accountInfo.getUid());
                        builder.put("vendorId", accountInfo.getVendorId());
                        builder.put("loginType", accountInfo.getLoginType());
                        builder.put("loginAccount", accountInfo.getLoginAccount());
                    }
                }

                //应用相关
                {
                    builder.put("versionCode", AppUtils.getVersionCode());
                    builder.put("versionName", AppUtils.getVersion());
                    builder.put("actionTime", TrueTime.getInstance().currentTimeMillis());
                    builder.put("timeStamp", System.currentTimeMillis());
                    builder.put("brand_id", getString(R.string.vod_mobile_brand));
                    builder.put("vno_id", getString(R.string.vod_mobile_vno));
                }

                //设备相关
                {
                    builder.put("mac", NetworkManager.getInstance().getMac());
                    builder.put("sdk", Build.VERSION.SDK_INT);
                    builder.put("language", DeviceUtils.getLocaleString());
                    builder.put("deviceType", "mobile");
                    builder.put("manufacturer", Build.MANUFACTURER);
                    builder.put("brand", Build.BRAND);
                    builder.put("model", Build.MODEL);
                    builder.put("productId", Build.PRODUCT);
                    builder.put("os", Build.VERSION.RELEASE);

                    DeviceInfo deviceInfo = HardwareManager.getInstance().getDeviceInfo();
                    if (deviceInfo != null) {
                        builder.put("cpuId", deviceInfo.getCpuSerial());
                        builder.put("romSize", deviceInfo.getRomSize());
                        builder.put("ramSize", deviceInfo.getRamSize());
                        builder.put("androidId", deviceInfo.getAndroidId());
                    }
                }

                //地理位置
                {
                    GeoIP geoIP = GeoIPManager.getInstance().getGeoIP();
                    if (geoIP != null) {
                        builder.put("region", geoIP.getCountryCode());
                    }
                }
                return builder.build();
            }).addMetricChain(MetricManager.MetricKey.PM, data -> data.newBuilder()
                    .put("app_id", BuildConfig.APP_ID)
                    .build());
        }

    }

    private void initHost() {
        HostUtils.CLOUD_DELEGATE_HOST = configuration.cloudDelegateHost();
        HostUtils.CLOUD_PLAY_MAGNET_DELEGATE_HOST = configuration.cloudPlayMagnetDelegateHost();
        HostUtils.FEEDBACK_HOST = configuration.feedbackHost();
        ImagePathCompletion.HOST_URL = configuration.imageHost();

        String appId = configuration.appId();
        VodSdkManager.getInstance().init(toHostKey(configuration),
                CommonParams.loadCommonAppParams(),
                "C007F4CDE6CBCC523D84FCB9278C8E9DC8A7BD46644636C9923BE2B7853F57670CFA0AC04E72031184276D2D1762692152E4642C1426F57309614C898F8BE01C9398E3277E3D27A08B57C1F3E0E09509E67B",
                appId, null);
    }

    @Override
    protected List<Class> modulesService() {
        ArrayList<Class> moduleServices = new ArrayList<>();
        for (String name : ModuleConfig.MODULES) {
            if (name.toLowerCase().contains("Account".toLowerCase())) {
                moduleServices.add(IAccountModuleService.class);
            } else if (name.toLowerCase().contains("NetDisk".toLowerCase())) {
                moduleServices.add(INetDiskModuleService.class);
            } else if (name.toLowerCase().contains("Home".toLowerCase())) {
                moduleServices.add(IHomeModuleService.class);
            } else if (name.toLowerCase().contains("Meta".toLowerCase())) {
                moduleServices.add(IMetaModuleService.class);
            } else if (name.toLowerCase().contains("Live".toLowerCase())) {
                moduleServices.add(ILiveModuleService.class);
            } else if (name.toLowerCase().contains("Ota".toLowerCase())) {
                moduleServices.add(IOtaModuleService.class);
            } else if (name.toLowerCase().contains("Play".toLowerCase())) {
                moduleServices.add(IPlayModuleService.class);
            } else if (name.toLowerCase().contains("Settings".toLowerCase())) {
                moduleServices.add(ISettingsModuleService.class);
            } else if (name.toLowerCase().contains("Message".toLowerCase())) {
                moduleServices.add(IMessageModuleService.class);
            } else if (name.toLowerCase().contains("Notify".toLowerCase())) {
                moduleServices.add(INotifyModuleService.class);
            } else if (name.toLowerCase().contains("Feedback".toLowerCase())) {
                moduleServices.add(IFeedBackModuleService.class);
            } else if (name.toLowerCase().contains("Profile".toLowerCase())) {
                moduleServices.add(IProfileModuleService.class);
            } else if (name.toLowerCase().contains("Firebase".toLowerCase())) {
                moduleServices.add(IFirebaseModuleService.class);
            }
        }
        return moduleServices;
    }


    @Override
    public void registerARouterComponent() {

    }

    public void init(Application context, VodConfiguration configuration, Runnable done) {
        this.configuration = configuration;
        initCb = done;
        originApp = context;
        attachBaseContext(context);
        onCreate();
    }

    public void onForeground(boolean isForeground) {
        if (isForeground) {
            onForeground();
        } else {
            onBackground();
            updateSessionId();
        }
    }

    @TrackingEvent_UserUseApp_Start
    private void onForeground() {

    }

    @TrackingEvent_UserUseApp_Stop
    private void onBackground() {

    }

    @Override
    public void registerActivityLifecycleCallbacks(ActivityLifecycleCallbacks callback) {
        checkInit();
        originApp.registerActivityLifecycleCallbacks(callback);
    }

    @Override
    public void unregisterActivityLifecycleCallbacks(ActivityLifecycleCallbacks callback) {
        checkInit();
        originApp.unregisterActivityLifecycleCallbacks(callback);
    }

    @Override
    public void registerComponentCallbacks(ComponentCallbacks callback) {
        checkInit();
        originApp.registerComponentCallbacks(callback);
    }

    @Override
    public void unregisterComponentCallbacks(ComponentCallbacks callback) {
        checkInit();
        originApp.unregisterComponentCallbacks(callback);
    }

    private void checkInit() {
        if (originApp == null) throw new RuntimeException("Vod init first!");
    }

    @Override
    public void onNormalTaskFinish(ITask task) {

    }

    @Override
    public void onAllNormalTaskFinish() {
        setInitResult(true);
    }

    @Override
    public void onNormalTasksFail() {
        setInitResult(false);
    }

    private void setInitResult(boolean result) {
        mAppBridge.setInitResult(result);
        if (initCb != null) {
            initCb.run();
            initCb = null;
        }
    }

    @Override
    public void onSituationTaskFinish(ITask task) {

    }

    private HashMap<HostKey, String> toHostKey(VodConfiguration configuration) {
        HashMap<HostKey, String> map = new HashMap<>();
        map.put(HostKey.HOST_ACCOUNT, configuration.accountHost());
        map.put(HostKey.HOST_CLOUD, configuration.cloudHost());
        map.put(HostKey.HOST_META, configuration.metaHost());
        map.put(HostKey.HOST_SUBTITLE, configuration.subtitleHost());
        map.put(HostKey.HOST_TRAILER, configuration.trailerHost());
        map.put(HostKey.HOST_PROFILE, configuration.profileHost());
        map.put(HostKey.HOST_TRACKER, configuration.trackerHost());
        map.put(HostKey.HOST_APP_CONFIG, configuration.appWebHost());
        map.put(HostKey.HOST_SHARE, configuration.shareHost());
        showInitHosts(configuration);
        return map;
    }

    private void showInitHosts(VodConfiguration configuration) {
        if (null == configuration) {
            Logger.e(TAG, "showInitHosts error, configuration is null");
        } else {
            Logger.i(TAG, "showInitHosts, HOST_ACCOUNT = " + configuration.accountHost()
                    + ", HOST_META = " + configuration.metaHost());
        }
    }

    private void initConfig() {
        if (null == configuration) {
            return;
        }
        AutherConfig.Builder.create().setHosts(configuration.accountHost()).setCallback(new AutherConfig.Callback() {
            @Override
            public String getToken() {
                return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getToken();
            }

            @Override
            public String getUid() {
                return "" + ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getUid();
            }

            @Override
            public boolean getIsUserActivated() {
                return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().isUserActivated();
            }

            @Override
            public boolean getIsLogin() {
                return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().isLogined();
            }

            @Override
            public long getSubAccountId() {
                return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getSubAccountId();
            }

            @Override
            public int getAccountType() {
                return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getAccountType();
            }
        }).apply();

        AppConfig.Builder.create().setHosts(configuration.appWebHost()).setCallback(new AppConfig.Callback() {
            @Override
            public String getToken() {
                return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getToken();
            }

            @Override
            public String getUid() {
                return String.valueOf(ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getUid());
            }
        }).apply();

        ProfileConfig.Builder.create()
                .setHosts(configuration.profileHost())
                .setCallback(new ProfileConfig.Callback() {
                    @Override
                    public String getToken() {
                        return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getToken();
                    }

                    @Override
                    public String getUid() {
                        return String.valueOf(ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getUid());
                    }

                    @Override
                    public boolean getIsUserActivated() {
                        return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().isUserActivated();
                    }

                    @Override
                    public boolean getIsLogin() {
                        return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().isLogined();
                    }

                    @Override
                    public long getSubAccountId() {
                        return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getSubAccountId();
                    }

                    @Override
                    public int getAccountType() {
                        return ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getAccountType();
                    }
                }).apply();

        Initialization.getInstance().addTask(InitializationTaskFactory.obtainSituationTask().withInitClass(AppConfigManager.class).withExecution(() -> {
            AppConfigManager.init(ContextProvider.getApplication());
            AppConfigManager.getInstance().startWakaMobile();
            return true;
        }).withAccount().withNetWork().withThread());

        //AppConfigManager.init(ContextProvider.getApplication());
        //AppConfigManager.getInstance().getGuideConfig();
    }

    private void initDensityUtil() {
        DisplayMetrics dm = getResources().getDisplayMetrics();
        DensityUtil.density = dm.density;
        DensityUtil.densityDPI = dm.densityDpi;
        DensityUtil.screenWidthPx = Math.min(dm.widthPixels, dm.heightPixels);
        DensityUtil.screenhightPx = Math.max(dm.widthPixels, dm.heightPixels);
        DensityUtil.screenWidthDip = DensityUtil.px2dip(this, DensityUtil.screenWidthPx);
        DensityUtil.screenHightDip = DensityUtil.px2dip(this, DensityUtil.screenhightPx);
    }

    private void initAutoSizeConfig() {
        AutoSizeConfig.getInstance()
                //是否让框架支持自定义 Fragment 的适配参数, 由于这个需求是比较少见的, 所以须要使用者手动开启
                //如果没有这个需求建议不开启
                .setCustomFragment(true)
                .setDesignHeightInDp(640)
                .setDesignWidthInDp(360)
                //是否屏蔽系统字体大小对 AndroidAutoSize 的影响, 如果为 true, App 内的字体的大小将不会跟随系统设置中字体大小的改变
                //如果为 false, 则会跟随系统设置中字体大小的改变, 默认为 false
                .setExcludeFontScale(true)
                //屏幕适配监听器
                .setOnAdaptListener(new onAdaptListener() {
                    @Override
                    public void onAdaptBefore(Object target, Activity activity) {
                        //使用以下代码, 可支持 Android 的分屏或缩放模式, 但前提是在分屏或缩放模式下当用户改变您 App 的窗口大小时
                        //系统会重绘当前的页面, 经测试在某些机型, 某些情况下系统不会重绘当前页面, ScreenUtils.getScreenSize(activity) 的参数一定要不要传 Application!!!
//                        AutoSizeConfig.getInstance().setScreenWidth(ScreenUtils.getScreenSize(activity)[0]);
//                        AutoSizeConfig.getInstance().setScreenHeight(ScreenUtils.getScreenSize(activity)[1]);
                        //使用以下代码, 可支持 Android 的分屏或缩放模式, 但前提是在分屏或缩放模式下当用户改变您 App 的窗口大小时
                        //系统会重绘当前的页面, 经测试在某些机型, 某些情况下系统不会重绘当前页面, ScreenUtils.getScreenSize(activity) 的参数一定要不要传 Application!!!
                        AutoSizeConfig.getInstance().setScreenWidth(ScreenUtils.getScreenSize(activity)[0]);
                        AutoSizeConfig.getInstance().setScreenHeight(ScreenUtils.getScreenSize(activity)[1]);
                        Logger.d(TAG, String.format(Locale.ENGLISH, "%s onAdaptBefore!", target.getClass().getName()));
                        if (activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                            //设置横屏设计尺寸
                            AutoSizeConfig.getInstance()
                                    .setDesignWidthInDp(640)
                                    .setDesignHeightInDp(360);
                        } else {
                            //设置竖屏设计尺寸
                            AutoSizeConfig.getInstance()
                                    .setDesignWidthInDp(360)
                                    .setDesignHeightInDp(640);
                        }
                    }

                    @Override
                    public void onAdaptAfter(Object target, Activity activity) {
                        Logger.d(TAG, String.format(Locale.ENGLISH, "%s onAdaptAfter!", target.getClass().getName()));
                    }
                })

                //是否打印 AutoSize 的内部日志, 默认为 true, 如果您不想 AutoSize 打印日志, 则请设置为 false
                .setLog(false)
        //是否使用设备的实际尺寸做适配, 默认为 false, 如果设置为 false, 在以屏幕高度为基准进行适配时
        //AutoSize 会将屏幕总高度减去状态栏高度来做适配
        //设置为 true 则使用设备的实际屏幕高度, 不会减去状态栏高度
//                .setUseDeviceSize(true)

        //是否全局按照宽度进行等比例适配, 默认为 true, 如果设置为 false, AutoSize 会全局按照高度进行适配
//                .setBaseOnWidth(false)

        //设置屏幕适配逻辑策略类, 一般不用设置, 使用框架默认的就好
//                .setAutoAdaptStrategy(new AutoAdaptStrategy())
        ;
    }
}
