package com.cv.media.aar;

import android.content.Context;

import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.cv.media.lib.common_utils.utils.AppUtils;
import com.cv.media.lib.common_utils.utils.DeviceUtils;
import com.cv.media.lib.common_utils.utils.JsonUtil;

import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Method;
import java.util.HashMap;

/**
 * Created by zhangyaoa on 2022-11-03.
 */
public class CommonParams {
    public static HashMap<String,String> loadCommonAppParams(){
        HashMap<String,String> params = new HashMap<>();
        //后端要求
        params.put("productId", "mfc");
        //后端要求
        params.put("productCode", getString(R.string.vod_mobile_brand));
        params.put("client", "mobile");
        params.put("channelDeviceType", getChannelDeviceType());
        params.put("preVendorId", DeviceUtils.getPreVendorId());
        params.put("vodSdkVersion","1000066");

        params.put("Vod-AppId", getString(R.string.vod_mobile_appid));
        params.put("Vod-Vno", GeneralApplication.isLocalRequest?"tuole":getString(R.string.vod_mobile_vno));
        params.put("Vod-Brand", GeneralApplication.isLocalRequest?"MFC":getString(R.string.vod_mobile_brand));
        params.put("Accept-Language", DeviceUtils.getLocaleString());
        params.put("Vod-AppVer", "3000066");
        params.put("channelId", getString(R.string.vod_mobile_sourceid));
        params.put("sourceId", getString(R.string.vod_mobile_sourceid));
        return params;
    }

    private static String getString(int id){
        return ContextProvider.getContext().getString(id);
    }

    private static final String[] propsKey = new String[]{
            "persist.sys.push",
            "ro.product.devicetype",
            "ro.kitking.devicetype",
            "ro.kontech.devicetype",
            "ro.zeasn.devicetype",
            "ro.selenview.devicetype",
            "ro.product.model",
            "mstar.zvt.devicetype",
            "ro.product.device",
            "ro.skyworth.devicetype",
            "ro.changhong.model",
            "ro.build.firmwaretag",
            "ro.haier.devicetype",
            "ro.kdp.devicetype",
            "ro.kdp.devicetypekid",
            "ro.tcl.client.type",
            "ro.nextgenpro.devicetype",
            "zeasnpublicdefalt",
            "TCLSCBCAndroidMsd338default",
            "ro.devicetype.zeasn",
    };

    private static Method getProp;
    private static Class systemProps;

    private static String getSystemProp(String key) {
        if (getProp == null) {
            try {
                systemProps = Context.class.getClassLoader().loadClass("android.os.SystemProperties");
                getProp = systemProps.getDeclaredMethod("get", String.class, String.class);
                getProp.setAccessible(true);
            } catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        try {
            return (String) getProp.invoke(systemProps, key, "");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String getChannelDeviceType() {
        HashMap<String, String> map = new HashMap<>();
        for (String key : propsKey) {
            String value = getSystemProp(key);
            if (!StringUtils.isEmpty(value)) map.put(key, value);
        }
        return JsonUtil.parseMapToJson(map);
    }
}
