package com.cv.media.aar;

import java.util.List;

import android.content.Context;

import androidx.fragment.app.Fragment;

import com.cv.media.c.meta.model.SimpleMeta;
import com.cv.media.c.server.model.BaseMeta;
import com.cv.media.lib.common_utils.callback.ICallBack;

import io.reactivex.Observable;
import io.reactivex.functions.Consumer;

/**
 * Vod 与 外界APP 交互接口
 */
public interface AppBridge {
    /**
     * 初始化结果
     *
     * @return 是否初始化成功
     */
    boolean isInitSuccess();

    /**
     * 获取首页页面
     *
     * @return 首页页面
     */
    Fragment getHomePage();

    /**
     * 获取不同的Fragment， 函数是公共的，根据type类型返回
     *
     * @return 首页页面
     */
    Fragment getCommonPage(int type);

    /**
     * 打开不同UI 窗口；函数是公共的，根据type类型打开
     */
    void toCommonPage(int type);

    /**
     * 打开详情页面
     *
     * @param context 上下文
     */
    void openDetailPage(long videoId, Context context);

    /**
     * 搜索
     *
     * @param searchText 搜索关键字
     * @return 返回搜索结果（按movieList、playList、personList排序）
     */
    Observable<List<SimpleMeta>> searchMetaForTVE(String searchText);

    /**
     * 获取播放列表
     *
     * @param playlistId 播放列表ID
     * @param pageId     第几页
     * @param pageSize   查询总页数
     * @return 播放列表
     */
    Observable<List<SimpleMeta>> getVideoListForTVE(long playlistId, int pageId, int pageSize);

    /**
     * 打开个人详情页
     *
     * @param metaId metaId
     */
    void openPersonPage(long metaId);

    /**
     * 登陆Vod
     *
     * @param token
     * @param accountId
     * @param distributeId
     * @param mac
     * @param loginId
     * @param expiredTime
     * @param cb
     */
    void login(String token, String accountId, String distributeId, String mac, String loginId, long expiredTime,
               ICallBack<Boolean> cb);

    /**
     * 登出
     */
    void logout();

    /**
     * 内部开发测试使用
     *
     * @param context 上下文
     * @param key     key值
     */
    void openLoginForLocalTestPage(Context context, int key);


    void registerVodTokenExpiredListener(Consumer<Boolean> consumer);

    /**
     * vod取消登录
     */
    void vodLoginCancel();

    Observable<Object> searchTabClickOnHomePage();

    /**
     *  pct强制开启
     */
    void pctForceEnable(boolean ref);
}
