package com.cv.media.aar;

import java.util.List;

import android.content.Context;

import androidx.fragment.app.Fragment;

import com.alibaba.android.arouter.launcher.ARouter;
import com.cv.media.c.interfaces.path.RoutePath_Account;
import com.cv.media.c.interfaces.path.RoutePath_Home;
import com.cv.media.c.interfaces.path.RoutePath_Meta;
import com.cv.media.c.interfaces.path.RoutePath_Settings;
import com.cv.media.c.interfaces.service.account.IAccountCallback;
import com.cv.media.c.interfaces.service.account.IAccountSerivce;
import com.cv.media.c.interfaces.service.play.IPlayService;
import com.cv.media.c.interfaces.service.home.IHomeService;
import com.cv.media.c.interfaces.service.vod.IMetaService;
import com.cv.media.c.meta.model.SimpleMeta;
import com.cv.media.c.server.model.BaseMeta;
import com.cv.media.lib.common_utils.callback.ICallBack;

import io.reactivex.Observable;
import io.reactivex.functions.Consumer;

class AppBridgeImpl implements AppBridge {
    public static final String PERSON_KEY = "personId";

    boolean initResult;

    public void setInitResult(boolean initResult) {
        this.initResult = initResult;
    }

    @Override
    public boolean isInitSuccess() {
        return initResult;
    }

    @Override
    public Fragment getHomePage() {
        return (Fragment) ARouter.getInstance().build(RoutePath_Home.Fragment.Home).navigation();
    }

    @Override
    public void openDetailPage(long videoId, Context context) {
        //ARouter.getInstance().navigation(IMetaService.class).openDetailPage(videoId, ttId, context);
        ARouter.getInstance().navigation(IPlayService.class).startVodPlayActivity(context, videoId);
    }

    @Override
    public Observable<List<SimpleMeta>> searchMetaForTVE(String searchText) {
        return ARouter.getInstance().navigation(IMetaService.class).searchMetaForTVE(searchText);
    }

    @Override
    public Observable<List<SimpleMeta>> getVideoListForTVE(long playlistId, int pageId, int pageSize) {
        return ARouter.getInstance().navigation(IMetaService.class).getVideoListForTVE(playlistId, pageId, pageSize);
    }

    @Override
    public void openPersonPage(long metaId) {
        ARouter.getInstance().build(RoutePath_Meta.Page.Stars).withLong(PERSON_KEY, metaId).navigation();
    }

    @Override
    public void login(String token, String accountId, String distributeId, String mac, String loginId, long expiredTime,
                      ICallBack<Boolean> cb) {
        ARouter.getInstance()
                .navigation(IAccountSerivce.class)
                .loginSilent(token, accountId, distributeId, mac, loginId, expiredTime, new IAccountCallback() {
                    @Override
                    public void success() {
                        cb.call(true);
                    }

                    @Override
                    public void failed(Throwable throwable) {
                        cb.call(false);
                    }
                });
    }

    @Override
    public void logout() {
        ARouter.getInstance().navigation(IAccountSerivce.class).logout();
    }

    @Override
    public void openLoginForLocalTestPage(Context context, int key) {
        switch (key) {
            case 0:
                ARouter.getInstance().build(RoutePath_Account.Page.Login).navigation(context);
                break;
            case 1:
                ARouter.getInstance().build(RoutePath_Settings.Page.Setting).navigation(context);
                break;
        }
    }

    @Override
    public void registerVodTokenExpiredListener(Consumer<Boolean> consumer) {
        ARouter.getInstance()
                .navigation(IAccountSerivce.class).registerVodTokenExpiredListener(consumer);
    }

    @Override
    public void vodLoginCancel() {
        ARouter.getInstance().navigation(IAccountSerivce.class).loginCancel();
    }

    @Override
    public Observable<Object> searchTabClickOnHomePage() {
        return ARouter.getInstance().navigation(IHomeService.class).observeHomeSearchClick();
    }
}
