package com.cv.media.aar;

import android.app.Application;
import android.os.Looper;
import android.text.TextUtils;

import com.cv.media.c.server.model.HostKey;
import com.cv.media.lib.metric.manager.MetricManager;

import java.util.HashMap;
import java.util.Map;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;

/**
 * 职责:
 * Vod初始化
 * 初始化回调
 *
 * @author Damon
 */
public class Vod {
    static GeneralApplication vodApp;

    /**
     * 获取metric 初始化Map
     */
    public static Map<String, String[]> metricMap() {
        String urls = BuildConfig.METRIC_HOST;
        Map<String, String[]> urlMap = new HashMap<>();
        if (!TextUtils.isEmpty(urls.replace(" ", ""))) {
            String[] urlsGroups = urls.split("#");

            for (int i = 0; i < urlsGroups.length; ++i) {
                String[] urlArray = null;
                if (!TextUtils.isEmpty(urlsGroups[i])) {
                    urlArray = urlsGroups[i].split(",");
                }

                if (i < MetricManager.MetricKey.values().length) {
                    urlMap.put(MetricManager.MetricKey.values()[i].name(), urlArray);
                }
            }
        }
        return urlMap;
    }

    /**
     * 初始化方法
     * 当获取到AppBridge代表初始化完成
     */
    public synchronized static Observable<AppBridge> init(Application originApp, VodConfiguration configuration) {
        if (vodApp != null)
            return Observable.create(emitter -> emitter.onNext(vodApp.getAppBridge()));
        vodApp = new GeneralApplication();
        return Observable.create(emitter -> {
            if (configuration == null) emitter.onError(new RuntimeException("configuration can't be null"));
            Runnable r = () -> vodApp.init(originApp, configuration, () -> emitter.onNext(vodApp.getAppBridge()));
            if (Looper.myLooper() != Looper.getMainLooper()) {
                emitter.onError(new RuntimeException("must run in UI thread!!!!!!!!!!!!!!!!!!!!!"));
            } else
                r.run();
        }).observeOn(AndroidSchedulers.mainThread()).map(o -> (AppBridge) o);
    }


}
