package com.cv.media.aar;

import android.content.Context;
import android.util.Pair;

import androidx.fragment.app.Fragment;

import com.cv.media.c.interfaces.service.vod.UiCfg;
import com.cv.media.c.server.model.BaseMeta;
import com.cv.media.c.server.model.MediaMeta;
import com.cv.media.c.server.model.Trailer;
import com.cv.media.lib.common_utils.callback.ICallBack;

import java.util.List;

import io.reactivex.Observable;
import io.reactivex.functions.Consumer;

/**
 * Vod 与 外界APP 交互接口
 */
public interface AppBridge {
    /**
     * 初始化结果
     *
     * @return 是否初始化成功
     */
    boolean isInitSuccess();

    /**
     * 获取首页页面
     *
     * @return 首页页面
     */
    Fragment getHomePage();

    /**
     * 获取设置页面
     *
     * @return 设置界面
     */
    Fragment getSettingPage();

    /**
     * 打开详情页面
     *
     * @param ttId    媒体id
     * @param context 上下文
     */
    void openDetailPage(long videoId, String ttId, Context context, String pageFrom);

    /**
     * 搜索
     *
     * @param searchText 搜索关键字
     * @return 返回搜索结果（按movieList、playList、personList排序）
     */
    Observable<List<BaseMeta>> searchMetaForTVE(String searchText);

    /**
     * 搜索
     *
     * @param searchText 搜索关键字，使用pp搜索
     * @return 返回搜索结果（按movieList、playList、personList排序）
     */
    Observable<List<BaseMeta>> searchByKeyForPp(String searchText);

    /**
     * 查询trailer
     * EMetaSource metaSource
     *
     * @param videoId 默认videoId
     * @param imdbId  使用imdbId，即ttid
     * @return 返回一组list
     */
    Observable<List<Trailer>> queryTrailer(long videoId, String imdbId);

    /**
     * 查询vod详情信息
     * videoID, EMetaSource.IMDB, exMetaID, R_LINKED_STATUS, "ARTWORK,TRAILER,CAST"
     *
     * @param videoID  影片ID
     * @param exMetaID ttid
     * @return
     */
    Observable<MediaMeta> getVideoDetail(long videoID, String exMetaID);

    /**
     * 获取播放列表
     *
     * @param playlistId 播放列表ID
     * @param pageId     第几页
     * @param pageSize   查询总页数
     * @return 播放列表
     */
    Observable<List<BaseMeta>> getVideoListForTVE(long playlistId, int pageId, int pageSize);

    /**
     * 打开个人详情页
     *
     * @param metaId metaId
     */
    void openPersonPage(long metaId, String pageFrom);

    /**
     * 登陆Vod
     *
     * @param token
     * @param accountId
     * @param distributeId
     * @param mac
     * @param loginId
     * @param expiredTime
     * @param cb
     */
    void login(String token, String accountId, String distributeId, String mac, String loginId, long expiredTime,
               ICallBack<Boolean> cb);

    /**
     * 登出
     */
    void logout();

    /**
     * 内部开发测试使用
     *
     * @param context 上下文
     * @param key     key值
     */
    void openLoginForLocalTestPage(Context context, int key);


    void registerVodTokenExpiredListener(Consumer<Boolean> consumer);

    /**
     * vod取消登录
     */
    void vodLoginCancel();

    /**
     * pct强制开启
     */
    void pctForceEnable(boolean ref);

    /**
     * 获取vod用户账号
     *
     * @return vod用户账号
     */
    long getAccountId();

    boolean isAutoPlayTrailer();

    void queryVodFragments(ICallBack<List<Pair<UiCfg, Fragment>>> callBack, ICallBack<Throwable> errorCb);

    void setFocusToTabListener(Consumer<Boolean> consumer);
}
