package com.cv.media.aar;

import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;

import com.alibaba.android.arouter.core.IARouterInitApplication;
import com.alibaba.android.arouter.launcher.ARouter;
import com.cv.media.account.CommonParams;
import com.cv.media.app.module.ModuleConfig;
import com.cv.media.c.interfaces.service.account.IAccountInfo;
import com.cv.media.c.interfaces.service.account.IAccountModuleService;
import com.cv.media.c.interfaces.service.account.IAccountSerivce;
import com.cv.media.c.interfaces.service.feedback.IFeedBackModuleService;
import com.cv.media.c.interfaces.service.firebase.IFirebaseModuleService;
import com.cv.media.c.interfaces.service.home.IHomeModuleService;
import com.cv.media.c.interfaces.service.live.ILiveModuleService;
import com.cv.media.c.interfaces.service.message.IMessageModuleService;
import com.cv.media.c.interfaces.service.netdisk.INetDiskModuleService;
import com.cv.media.c.interfaces.service.notify.INotifyModuleService;
import com.cv.media.c.interfaces.service.ota.IOtaModuleService;
import com.cv.media.c.interfaces.service.play.IPlayModuleService;
import com.cv.media.c.interfaces.service.profile.IProfileModuleService;
import com.cv.media.c.interfaces.service.settings.ISettingsModuleService;
import com.cv.media.c.interfaces.service.vod.IMetaModuleService;
import com.cv.media.c.server.model.HostKey;
import com.cv.media.c.tracking.LaunchProtocol;
import com.cv.media.c.tracking.MfcTracking;
import com.cv.media.c.tracking.PageBrowseInfoCollector;
import com.cv.media.c.tracking.events.TrackingEvent_UserUseApp_Start;
import com.cv.media.c.tracking.events.TrackingEvent_UserUseApp_Stop;
import com.cv.media.c.ui.glide.ImagePathCompletion;
import com.cv.media.lib.common_utils.appinit.IInitializationSituationTask;
import com.cv.media.lib.common_utils.appinit.ITask;
import com.cv.media.lib.common_utils.appinit.Initialization;
import com.cv.media.lib.common_utils.appinit.InitializationTaskFactory;
import com.cv.media.lib.common_utils.appstat.AppManager;
import com.cv.media.lib.common_utils.appstat.features.IAppFeatures;
import com.cv.media.lib.common_utils.laucher.DataFromLaunch;
import com.cv.media.lib.common_utils.ntp.TrueTime;
import com.cv.media.lib.common_utils.utils.AppUtils;
import com.cv.media.lib.common_utils.utils.DeviceUtils;
import com.cv.media.lib.common_utils.utils.GsonUtil;
import com.cv.media.lib.common_utils.utils.MD5Utils;
import com.cv.media.lib.common_utils.utils.storage.DirectoryUtils;
import com.cv.media.lib.geoip.manager.GeoIPManager;
import com.cv.media.lib.geoip.model.GeoIP;
import com.cv.media.lib.hardware.device.DeviceInfo;
import com.cv.media.lib.hardware.device.HardwareManager;
import com.cv.media.lib.hardware.network.NetworkManager;
import com.cv.media.lib.log.Logger;
import com.cv.media.lib.metric.data.MetricData;
import com.cv.media.lib.metric.devmetric.MetricAgentManager;
import com.cv.media.lib.metric.manager.MetricManager;
import com.cv.media.lib.mvx.base.BaseApplication;
import com.cv.media.lib.mvx.compArch.HostApplication;
import com.cv.media.lib.tracker.TrackingService;
import com.cv.media.lib.ui.progressview.ProgressManager;
import com.cv.media.m.external.VodSdkManager;
import com.cv.media.m.meta.vod.app.MetaApplication;
import com.cv.media.m.player.utils.HostUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import io.reactivex.disposables.Disposable;

public class GeneralApplication extends HostApplication implements IARouterInitApplication, Initialization.InitializationListener {
    AppBridgeImpl mAppBridge = new AppBridgeImpl();
    Application originApp;
    private static final String TAG = BaseApplication.class.getSimpleName();
    String sessionId;
    Runnable initCb;
    VodConfiguration configuration;

    protected void updateSessionId() {
        sessionId = MD5Utils.MD5(System.currentTimeMillis() + "");
    }

    public AppBridge getAppBridge() {
        return mAppBridge;
    }

    @Override
    public void onCreate() {
        HostUtils.CLOUD_DELEGATE_HOST = configuration.cloudDelegateHost();
        HostUtils.CLOUD_PLAY_MAGNET_DELEGATE_HOST = configuration.cloudPlayMagnetDelegateHost();
        MetaApplication.AutherHost = configuration.accountHost();
        MetaApplication.ProfileHost = configuration.profileHost();
        MetaApplication.webConfigHost = configuration.webConfigHost();
        ImagePathCompletion.HOST_URL = configuration.imageHost();

        String appId = configuration.appId();
        VodSdkManager.getInstance().init(configuration.useThirdAccount(), toHostKey(configuration),
                CommonParams.loadCommonAppParams(),
                "C007F4CDE6CBCC523D84FCB9278C8E9DC8A7BD46644636C9923BE2B7853F57670CFA0AC04E72031184276D2D1762692152E4642C1426F57309614C898F8BE01C9398E3277E3D27A08B57C1F3E0E09509E67B",
                appId, configuration.soPath());
        MetricManager.init(this, BuildConfig.APP_ID, BuildConfig.METRIC_HOST, null, BuildConfig.FLAVOR_platform + "_");
        TrackingService.setWorkingTrackingAPI(MfcTracking.class);
        ProgressManager.initLoadingDialogStyle(R.style.CUILoadingDialogStyle, R.drawable.c_ui_progress_loading_circle_draw,R.dimen.c_ui_sm_25);
        updateSessionId();
        Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
        registerActivityLifecycleCallbacks(PageBrowseInfoCollector.getInstance());
        Initialization.getInstance().addListener(this);
        Initialization.getInstance().attachNetWorkObservable(new NetWorkObservable());
        Disposable ignore = AppManager.INSTANCE.getApp().appStatChanged().subscribe(appStat -> {
            onForeground(appStat == IAppFeatures.AppStat.Foreground);
        });
        DataFromLaunch.getInstance().reg(LaunchProtocol.KEY_FROM_APP_ID);
        DirectoryUtils.init(BuildConfig.APP_ID);

        Initialization.getInstance().addTask(InitializationTaskFactory.obtainNormalTask().withExecution(new Runnable() {
            @Override
            public void run() {
                HashMap<String, String> tagMap = new HashMap<>();
                try {
                    tagMap.put("localPostTime", String.valueOf(TrueTime.getInstance().currentTimeMillis()));
                    tagMap.put("language", DeviceUtils.getLocaleString());
                    tagMap.put("appVer", String.valueOf(AppUtils.getVersionCode()));
                    tagMap.putAll(GsonUtil.getGson().fromJson(GsonUtil.getGson().toJson(HardwareManager.getInstance().getDeviceInfo()), HashMap.class));
                } catch (Exception e) {
                    e.printStackTrace();
                }

                MetricAgentManager.init(tagMap, BuildConfig.METRICAGENT_APPID, BuildConfig.METRICAGENT_APPKEY, BuildConfig.METRICAGENT_HOST);
            }
        }).withInitClass(MetricAgentManager.class).withThread());

        super.onCreate();

        //埋点公共参数配置
        {
            WindowManager windowManager = (WindowManager) getSystemService(Context.WINDOW_SERVICE);
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
            MetricManager.getInstance().addMetricChain(data -> {
                MetricData.Builder builder = data.newBuilder();
                IAccountInfo accountInfo = ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo();
                //保留属性
                {
                    if (accountInfo != null && accountInfo.isLogined()) {
                        builder.put("uid", accountInfo.getAccountId() + "" + accountInfo.getAccountType());
                        builder.put("account_id", accountInfo.getAccountId());
                        //0-device，2-account card，4-code（对于LIVE，输入code也会创建一个账号），1-email，3-phone
                        builder.put("login_type", accountInfo.getLoginMethod());
                        builder.put("account_name", accountInfo.getAccountName());
                        builder.put("account_source", accountInfo.getAccountSource());
                        builder.put("is_expired", accountInfo.isExpired() ? 1 : 0);
                        builder.put("valid_date", accountInfo.expireTs());
                        builder.put("user_status", accountInfo.isFreeTrialUser() ? 1 : 0);
                    }

                    builder.put("action_time", TrueTime.getInstance().currentTimeMillis());
                    builder.put("session_id", sessionId);
                    builder.put("page_path", PageBrowseInfoCollector.getInstance().getPagePath());
                }

                //应用相关
                {
                    builder.put("release_id", configuration.releaseId());
                    builder.put("source_id", "waka");
                    try {
                        if (accountInfo != null)
                            builder.put("vendor_id", accountInfo.getVendorId());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    builder.put("app_name", getResources().getString(getApplicationInfo().labelRes));
                    builder.put("ver_code", AppUtils.getVersionCode());
                    builder.put("basever_code", null);
                    builder.put("brand_id", "WAKA");
                    builder.put("product_id", null);
                    builder.put("vno_id", "waka");
                }

                //设备相关
                {
                    builder.put("mac", NetworkManager.getInstance().getMac());
                    builder.put("terminal_type", "box");
                    builder.put("manufacturer", Build.MANUFACTURER);
                    builder.put("brand", Build.BRAND);
                    builder.put("model", Build.MODEL);
                    builder.put("os", "Android");
                    builder.put("android_version", Build.VERSION.RELEASE);
                    builder.put("sdk", Build.VERSION.SDK_INT);
                    builder.put("screen_width", displayMetrics.widthPixels);
                    builder.put("screen_height", displayMetrics.heightPixels);
                    builder.put("net_state", NetworkManager.getInstance().isEthernetConnected() ? "ethernet" : (NetworkManager.getInstance().isWifiConnected() ? "wifi" : null));
                    builder.put("browser", null);
                    builder.put("browser_version", null);
                    builder.put("carrier", null);
                    builder.put("system_language", DeviceUtils.getLocaleString());
                }

                //地理位置
                {
                    GeoIP geoIP = GeoIPManager.getInstance().getGeoIP();
                    if (geoIP != null) {
                        builder.put("timezone", geoIP.getTimeZone());
                        builder.put("ip", geoIP.getIp());
                        builder.put("country", geoIP.getCountryName());
                        builder.put("city", geoIP.getCity());
                        builder.put("province", geoIP.getRegionName());
                    }
                }
                return builder.build();
            }).addMetricChain(MetricManager.MetricKey.SLA, data -> {
                MetricData.Builder builder = data.newBuilder();

                IAccountInfo accountInfo = ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo();
                //保留属性
                {
                    if (accountInfo != null && accountInfo.isLogined()) {
                        builder.put("uid", accountInfo.getAccountId() + "" + accountInfo.getAccountType());
                        builder.put("accountId", accountInfo.getAccountId());
                        builder.put("vendorId", accountInfo.getVendorId());
                        builder.put("loginType", accountInfo.getLoginType());
                        builder.put("loginAccount", accountInfo.getLoginAccount());
                    }
                }

                //应用相关
                {
                    builder.put("versionCode", AppUtils.getVersionCode());
                    builder.put("versionName", AppUtils.getVersion());
                    builder.put("actionTime", TrueTime.getInstance().currentTimeMillis());
                    builder.put("timeStamp", System.currentTimeMillis());
                    builder.put("brand_id", "WAKA");
                    builder.put("product_id", null);
                    builder.put("vno_id", "waka");
                }

                //设备相关
                {
                    builder.put("mac", NetworkManager.getInstance().getMac());
                    builder.put("sdk", Build.VERSION.SDK_INT);
                    builder.put("language", DeviceUtils.getLocaleString());
                    builder.put("deviceType", "box");
                    builder.put("manufacturer", Build.MANUFACTURER);
                    builder.put("brand", Build.BRAND);
                    builder.put("model", Build.MODEL);
                    builder.put("productId", Build.PRODUCT);
                    builder.put("os", Build.VERSION.RELEASE);

                    DeviceInfo deviceInfo = HardwareManager.getInstance().getDeviceInfo();
                    if (deviceInfo != null) {
                        builder.put("cpuId", deviceInfo.getCpuSerial());
                        builder.put("romSize", deviceInfo.getRomSize());
                        builder.put("ramSize", deviceInfo.getRamSize());
                        builder.put("androidId", deviceInfo.getAndroidId());
                    }
                }

                //地理位置
                {
                    GeoIP geoIP = GeoIPManager.getInstance().getGeoIP();
                    if (geoIP != null) {
                        builder.put("region", geoIP.getCountryCode());
                    }
                }
                return builder.build();
            }).addMetricChain(MetricManager.MetricKey.PM, data -> data.newBuilder()
                    .put("app_id", BuildConfig.APP_ID)
                    .build());
        }

    }

    @Override
    protected List<Class> modulesService() {
        ArrayList<Class> moduleServices = new ArrayList<>();
        for (String name : ModuleConfig.MODULES) {
            if (name.toLowerCase().contains("Account".toLowerCase())) {
                moduleServices.add(IAccountModuleService.class);
            } else if (name.toLowerCase().contains("NetDisk".toLowerCase())) {
                moduleServices.add(INetDiskModuleService.class);
            } else if (name.toLowerCase().contains("Home".toLowerCase())) {
                moduleServices.add(IHomeModuleService.class);
            } else if (name.toLowerCase().contains("Meta".toLowerCase())) {
                moduleServices.add(IMetaModuleService.class);
            } else if (name.toLowerCase().contains("Live".toLowerCase())) {
                moduleServices.add(ILiveModuleService.class);
            } else if (name.toLowerCase().contains("Ota".toLowerCase())) {
                moduleServices.add(IOtaModuleService.class);
            } else if (name.toLowerCase().contains("Play".toLowerCase())) {
                moduleServices.add(IPlayModuleService.class);
            } else if (name.toLowerCase().contains("Settings".toLowerCase())) {
                moduleServices.add(ISettingsModuleService.class);
            } else if (name.toLowerCase().contains("Message".toLowerCase())) {
                moduleServices.add(IMessageModuleService.class);
            } else if (name.toLowerCase().contains("Notify".toLowerCase())) {
                moduleServices.add(INotifyModuleService.class);
            } else if (name.toLowerCase().contains("Feedback".toLowerCase())) {
                moduleServices.add(IFeedBackModuleService.class);
            } else if (name.toLowerCase().contains("Profile".toLowerCase())) {
                moduleServices.add(IProfileModuleService.class);
            } else if (name.toLowerCase().contains("Firebase".toLowerCase())) {
                moduleServices.add(IFirebaseModuleService.class);
            }
        }
        return moduleServices;
    }


    @Override
    public void registerARouterComponent() {

    }

    public void init(Application context, VodConfiguration configuration, Runnable done) {
        this.configuration = configuration;
        initCb = done;
        originApp = context;
        attachBaseContext(context);
        onCreate();
    }

    public void onForeground(boolean isForeground) {
        if (isForeground) {
            onForeground();
        } else {
            onBackground();
            updateSessionId();
        }
    }

    @TrackingEvent_UserUseApp_Start
    private void onForeground() {

    }

    @TrackingEvent_UserUseApp_Stop
    private void onBackground() {

    }

    @Override
    public void registerActivityLifecycleCallbacks(ActivityLifecycleCallbacks callback) {
        checkInit();
        originApp.registerActivityLifecycleCallbacks(callback);
    }

    @Override
    public void unregisterActivityLifecycleCallbacks(ActivityLifecycleCallbacks callback) {
        checkInit();
        originApp.unregisterActivityLifecycleCallbacks(callback);
    }

    @Override
    public void registerComponentCallbacks(ComponentCallbacks callback) {
        checkInit();
        originApp.registerComponentCallbacks(callback);
    }

    @Override
    public void unregisterComponentCallbacks(ComponentCallbacks callback) {
        checkInit();
        originApp.unregisterComponentCallbacks(callback);
    }

    private void checkInit() {
        if (originApp == null) throw new RuntimeException("Vod init first!");
    }

    @Override
    public void onNormalTaskFinish(ITask task) {

    }

    @Override
    public void onAllNormalTaskFinish() {
        setInitResult(true);
    }

    @Override
    public void onNormalTasksFail() {
        setInitResult(false);
    }

    @Override
    public void onSituationTaskFinish(ITask task) {

    }

    private void setInitResult(boolean result) {
        mAppBridge.setInitResult(result);
        if (initCb != null) {
            initCb.run();
            initCb = null;
        }
    }

    private HashMap<HostKey, String> toHostKey(VodConfiguration configuration) {
        HashMap<HostKey, String> map = new HashMap<>();
        map.put(HostKey.HOST_ACCOUNT, configuration.accountHost());
        map.put(HostKey.HOST_CLOUD, configuration.cloudHost());
        map.put(HostKey.HOST_META, configuration.metaHost());
        map.put(HostKey.HOST_SUBTITLE, configuration.subtitleHost());
        map.put(HostKey.HOST_TRAILER, configuration.trailerHost());
        map.put(HostKey.HOST_PROFILE, configuration.profileHost());
        map.put(HostKey.HOST_ENGINE_CONFIG, configuration.webConfigHost());
        map.put(HostKey.HOST_TRACKER, configuration.trackerHost());
        showInitHosts(configuration);
        return map;
    }

    private void showInitHosts(VodConfiguration configuration) {
        if (null == configuration) {
            Logger.e(TAG, "showInitHosts error, configuration is null");
        } else {
            Logger.i(TAG, "showInitHosts, HOST_ACCOUNT = " + configuration.accountHost()
                    + ", HOST_META = " + configuration.metaHost());
        }
    }
}
