package com.cv.media.aar;

import com.cv.media.lib.hardware.network.ENetworkState;
import com.cv.media.lib.hardware.network.NetworkManager;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

class NetWorkObservable extends Observable<Boolean> {
    Observer<? super Boolean> observer;

    public NetWorkObservable() {
        NetworkManager.getInstance().addNetworkListener(new NetworkManager.NetWorkListener() {
            @Override
            public void onNetworkChanged(ENetworkState networkState) {
                checkAndPush();
            }
        });
    }

    @Override
    protected void subscribeActual(Observer<? super Boolean> observer) {
        this.observer = observer;
        observer.onSubscribe(new Disposable() {
            @Override
            public void dispose() {

            }

            @Override
            public boolean isDisposed() {
                return false;
            }
        });
        checkAndPush();
    }


    private void checkAndPush() {
        if(observer != null) {
            if(NetworkManager.getInstance().isNetworkConnected()) {
                observer.onNext(true);
            }else {
                observer.onNext(false);
            }
        }
    }
}
