/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion.msoffice;

import com.documents4j.api.DocumentType;
import com.documents4j.conversion.ViableConversion;
import com.documents4j.conversion.msoffice.AbstractMicrosoftOfficeBridge;
import com.documents4j.conversion.msoffice.MicrosoftOfficeFormat;
import com.documents4j.conversion.msoffice.MicrosoftOfficeScript;
import com.documents4j.conversion.msoffice.MicrosoftOfficeTargetNameCorrector;
import com.documents4j.conversion.msoffice.MicrosoftWordFormat;
import com.documents4j.conversion.msoffice.MicrosoftWordScript;
import com.documents4j.conversion.msoffice.MicrosoftWordTargetNameCorrector;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ViableConversion(from={"application/pdf", "application/vnd.com.documents4j.pdf-a", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.com.documents4j.any-msword", "application/rtf", "application/xml", "application/x-mimearchive", "text/plain"}, to={"application/pdf", "application/vnd.com.documents4j.pdf-a", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/rtf", "application/xml", "application/x-mimearchive", "text/plain"})
public class MicrosoftWordBridge
extends AbstractMicrosoftOfficeBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrosoftWordBridge.class);
    private static final Object WORD_LOCK = new Object();

    public MicrosoftWordBridge(File baseFolder, long processTimeout, TimeUnit processTimeoutUnit) {
        super(baseFolder, processTimeout, processTimeoutUnit, (MicrosoftOfficeScript)MicrosoftWordScript.CONVERSION);
        this.startUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUp() {
        Object object = WORD_LOCK;
        synchronized (object) {
            this.tryStart(MicrosoftWordScript.STARTUP);
            LOGGER.info("From-Microsoft-Word-Converter was started successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Object object = WORD_LOCK;
        synchronized (object) {
            this.tryStop(MicrosoftWordScript.SHUTDOWN);
            LOGGER.info("From-Microsoft-Word-Converter was shut down successfully");
        }
    }

    protected MicrosoftOfficeTargetNameCorrector targetNameCorrector(File target, String fileExtension) {
        return new MicrosoftWordTargetNameCorrector(target, fileExtension);
    }

    protected MicrosoftOfficeFormat formatOf(DocumentType documentType) {
        return MicrosoftWordFormat.of(documentType);
    }

    protected MicrosoftOfficeScript getAssertionScript() {
        return MicrosoftWordScript.ASSERTION;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

