/* DO NOT EDIT */
/* This file was generated from paper.stone */

package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;
import java.util.Arrays;

public enum PaperDocCreateError {
    // union paper.PaperDocCreateError (paper.stone)
    /**
     * Your account does not have permissions to perform this action. This may
     * be due to it only having access to Paper as files in the Dropbox
     * filesystem. For more information, refer to the <a
     * href="https://www.dropbox.com/lp/developers/reference/paper-migration-guide">Paper
     * Migration Guide</a>.
     */
    INSUFFICIENT_PERMISSIONS,
    /**
     * Catch-all used for unknown tag values returned by the Dropbox servers.
     *
     * <p> Receiving a catch-all value typically indicates this SDK version is
     * not up to date. Consider updating your SDK version to handle the new
     * tags. </p>
     */
    OTHER,
    /**
     * The provided content was malformed and cannot be imported to Paper.
     */
    CONTENT_MALFORMED,
    /**
     * The specified Paper folder is cannot be found.
     */
    FOLDER_NOT_FOUND,
    /**
     * The newly created Paper doc would be too large. Please split the content
     * into multiple docs.
     */
    DOC_LENGTH_EXCEEDED,
    /**
     * The imported document contains an image that is too large. The current
     * limit is 1MB. This only applies to HTML with data URI.
     */
    IMAGE_SIZE_EXCEEDED;

    /**
     * For internal use only.
     */
    static class Serializer extends UnionSerializer<PaperDocCreateError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(PaperDocCreateError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case INSUFFICIENT_PERMISSIONS: {
                    g.writeString("insufficient_permissions");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case CONTENT_MALFORMED: {
                    g.writeString("content_malformed");
                    break;
                }
                case FOLDER_NOT_FOUND: {
                    g.writeString("folder_not_found");
                    break;
                }
                case DOC_LENGTH_EXCEEDED: {
                    g.writeString("doc_length_exceeded");
                    break;
                }
                case IMAGE_SIZE_EXCEEDED: {
                    g.writeString("image_size_exceeded");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + value);
                }
            }
        }

        @Override
        public PaperDocCreateError deserialize(JsonParser p) throws IOException, JsonParseException {
            PaperDocCreateError value;
            boolean collapsed;
            String tag;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = getStringValue(p);
                p.nextToken();
            }
            else {
                collapsed = false;
                expectStartObject(p);
                tag = readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: " + TAG_FIELD);
            }
            else if ("insufficient_permissions".equals(tag)) {
                value = PaperDocCreateError.INSUFFICIENT_PERMISSIONS;
            }
            else if ("other".equals(tag)) {
                value = PaperDocCreateError.OTHER;
            }
            else if ("content_malformed".equals(tag)) {
                value = PaperDocCreateError.CONTENT_MALFORMED;
            }
            else if ("folder_not_found".equals(tag)) {
                value = PaperDocCreateError.FOLDER_NOT_FOUND;
            }
            else if ("doc_length_exceeded".equals(tag)) {
                value = PaperDocCreateError.DOC_LENGTH_EXCEEDED;
            }
            else if ("image_size_exceeded".equals(tag)) {
                value = PaperDocCreateError.IMAGE_SIZE_EXCEEDED;
            }
            else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                skipFields(p);
                expectEndObject(p);
            }
            return value;
        }
    }
}
