/* DO NOT EDIT */
/* This file was generated from team_folders.stone */

package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;
import java.util.Arrays;

public enum TeamFolderAccessError {
    // union team.TeamFolderAccessError (team_folders.stone)
    /**
     * The team folder ID is invalid.
     */
    INVALID_TEAM_FOLDER_ID,
    /**
     * The authenticated app does not have permission to manage that team
     * folder.
     */
    NO_ACCESS,
    /**
     * Catch-all used for unknown tag values returned by the Dropbox servers.
     *
     * <p> Receiving a catch-all value typically indicates this SDK version is
     * not up to date. Consider updating your SDK version to handle the new
     * tags. </p>
     */
    OTHER; // *catch_all

    /**
     * For internal use only.
     */
    static class Serializer extends UnionSerializer<TeamFolderAccessError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(TeamFolderAccessError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case INVALID_TEAM_FOLDER_ID: {
                    g.writeString("invalid_team_folder_id");
                    break;
                }
                case NO_ACCESS: {
                    g.writeString("no_access");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public TeamFolderAccessError deserialize(JsonParser p) throws IOException, JsonParseException {
            TeamFolderAccessError value;
            boolean collapsed;
            String tag;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = getStringValue(p);
                p.nextToken();
            }
            else {
                collapsed = false;
                expectStartObject(p);
                tag = readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: " + TAG_FIELD);
            }
            else if ("invalid_team_folder_id".equals(tag)) {
                value = TeamFolderAccessError.INVALID_TEAM_FOLDER_ID;
            }
            else if ("no_access".equals(tag)) {
                value = TeamFolderAccessError.NO_ACCESS;
            }
            else {
                value = TeamFolderAccessError.OTHER;
            }
            if (!collapsed) {
                skipFields(p);
                expectEndObject(p);
            }
            return value;
        }
    }
}
