/* DO NOT EDIT */
/* This file was generated by Stone */

package com.dropbox.core.v2.teamlog;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.teamcommon.TimeRange;

/**
 * The request builder returned by {@link
 * DbxTeamTeamLogRequests#getEventsBuilder}.
 *
 * <p> Use this class to set optional request parameters and complete the
 * request. </p>
 */
public class GetEventsBuilder {
    private final DbxTeamTeamLogRequests _client;
    private final GetTeamEventsArg.Builder _builder;

    /**
     * Creates a new instance of this builder.
     *
     * @param _client  Dropbox namespace-specific client used to issue team_log
     *     requests.
     * @param _builder  Request argument builder.
     *
     * @return instsance of this builder
     */
    GetEventsBuilder(DbxTeamTeamLogRequests _client, GetTeamEventsArg.Builder _builder) {
        if (_client == null) {
            throw new NullPointerException("_client");
        }
        this._client = _client;
        if (_builder == null) {
            throw new NullPointerException("_builder");
        }
        this._builder = _builder;
    }

    /**
     * Set value for optional field.
     *
     * <p> If left unset or set to {@code null}, defaults to {@code 1000L}. </p>
     *
     * @param limit  The maximal number of results to return per call. Note that
     *     some calls may not return {@link GetTeamEventsArg#getLimit} number of
     *     events, and may even return no events, even with `has_more` set to
     *     true. In this case, callers should fetch again using {@link
     *     DbxTeamTeamLogRequests#getEventsContinue(String)}. Must be greater
     *     than or equal to 1 and be less than or equal to 1000. Defaults to
     *     {@code 1000L} when set to {@code null}.
     *
     * @return this builder
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public GetEventsBuilder withLimit(Long limit) {
        this._builder.withLimit(limit);
        return this;
    }

    /**
     * Set value for optional field.
     *
     * @param accountId  Filter the events by account ID. Return only events
     *     with this account_id as either Actor, Context, or Participants. Must
     *     have length of at least 40 and have length of at most 40.
     *
     * @return this builder
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public GetEventsBuilder withAccountId(String accountId) {
        this._builder.withAccountId(accountId);
        return this;
    }

    /**
     * Set value for optional field.
     *
     * @param time  Filter by time range.
     *
     * @return this builder
     */
    public GetEventsBuilder withTime(TimeRange time) {
        this._builder.withTime(time);
        return this;
    }

    /**
     * Set value for optional field.
     *
     * @param category  Filter the returned events to a single category. Note
     *     that category shouldn't be provided together with event_type.
     *
     * @return this builder
     */
    public GetEventsBuilder withCategory(EventCategory category) {
        this._builder.withCategory(category);
        return this;
    }

    /**
     * Set value for optional field.
     *
     * @param eventType  Filter the returned events to a single event type. Note
     *     that event_type shouldn't be provided together with category.
     *
     * @return this builder
     */
    public GetEventsBuilder withEventType(EventTypeArg eventType) {
        this._builder.withEventType(eventType);
        return this;
    }

    /**
     * Issues the request.
     */
    public GetTeamEventsResult start() throws GetTeamEventsErrorException, DbxException {
        GetTeamEventsArg arg_ = this._builder.build();
        return _client.getEvents(arg_);
    }
}
