/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum UploadSessionType {
    SEQUENTIAL,
    CONCURRENT,
    OTHER;


    static class Serializer
    extends UnionSerializer<UploadSessionType> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UploadSessionType value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case SEQUENTIAL: {
                    g.writeString("sequential");
                    break;
                }
                case CONCURRENT: {
                    g.writeString("concurrent");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public UploadSessionType deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            UploadSessionType value = "sequential".equals(tag) ? SEQUENTIAL : ("concurrent".equals(tag) ? CONCURRENT : OTHER);
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

