/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.http.ForestFuture;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class Forest {
    public static ForestConfiguration config() {
        return ForestConfiguration.configuration();
    }

    public static ForestConfiguration config(String id) {
        return ForestConfiguration.configuration(id);
    }

    public static <T> T client(Class<T> clazz) {
        return Forest.config().createInstance(clazz);
    }

    public static ForestRequest<?> request() {
        return Forest.config().request();
    }

    public static <R> ForestRequest<R> request(Class<R> clazz) {
        return Forest.config().request(clazz);
    }

    public static ForestRequest<?> get(String url) {
        return Forest.config().get(url);
    }

    public static ForestRequest<?> post(String url) {
        return Forest.config().post(url);
    }

    public static ForestRequest<?> put(String url) {
        return Forest.config().put(url);
    }

    public static ForestRequest<?> delete(String url) {
        return Forest.config().delete(url);
    }

    public static ForestRequest<?> head(String url) {
        return Forest.config().head(url);
    }

    public static ForestRequest<?> patch(String url) {
        return Forest.config().patch(url);
    }

    public static ForestRequest<?> options(String url) {
        return Forest.config().options(url);
    }

    public static ForestRequest<?> trace(String url) {
        return Forest.config().trace(url);
    }

    public static List<ForestResponse> await(ForestFuture ... futures) {
        return Arrays.stream(futures).map(ForestFuture::await).collect(Collectors.toList());
    }

    public static List<ForestResponse> await(Collection<ForestFuture> futures) {
        return futures.stream().map(ForestFuture::await).collect(Collectors.toList());
    }

    public static void await(Collection<ForestFuture> futures, Consumer<ForestResponse> callback) {
        for (ForestFuture future : futures) {
            future.await();
        }
        for (ForestFuture future : futures) {
            callback.accept(future.getResponse());
        }
    }
}

