/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend;

import com.dtflys.forest.backend.AsyncHttpExecutor;
import com.dtflys.forest.backend.ForestConnectionManager;
import com.dtflys.forest.backend.HttpBackend;
import com.dtflys.forest.backend.HttpExecutor;
import com.dtflys.forest.backend.ResponseHandler;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.utils.AsyncUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class AbstractHttpBackend
implements HttpBackend {
    private HttpBackend.HttpExecutorCreator SYNC_EXECUTOR_CREATOR = this::createSyncExecutor;
    private HttpBackend.HttpExecutorCreator ASYNC_EXECUTOR_CREATOR = this::createAsyncExecutor;
    private HttpBackend.HttpExecutorCreator KOTLIN_COROUTINE_EXECUTOR_CREATOR = this::createKotlinCoroutineExecutor;
    private static AsyncHttpExecutorCreator ASYNC_HTTP_EXECUTOR_CREATOR;
    private static AsyncHttpExecutorCreator KOTLIN_COROUTINE_HTTP_EXECUTOR_CREATOR;
    private volatile boolean initialized = false;
    private final ForestConnectionManager connectionManager;
    private static Constructor<?> kotlinCoroutineExecutorConstructor;

    public AbstractHttpBackend(ForestConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ForestConfiguration configuration) {
        if (!this.initialized) {
            AbstractHttpBackend abstractHttpBackend = this;
            synchronized (abstractHttpBackend) {
                if (!this.initialized) {
                    this.connectionManager.init(configuration);
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public ForestConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public abstract HttpExecutor createSyncExecutor(ForestConnectionManager var1, ForestRequest var2, LifeCycleHandler var3);

    public HttpExecutor createAsyncExecutor(ForestConnectionManager connectionManager, ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        HttpExecutor syncHttpExecutor = this.createSyncExecutor(connectionManager, request, lifeCycleHandler);
        return ASYNC_HTTP_EXECUTOR_CREATOR.create(request.getConfiguration(), syncHttpExecutor, syncHttpExecutor.getResponseHandler());
    }

    public HttpExecutor createKotlinCoroutineExecutor(ForestConnectionManager connectionManager, ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        HttpExecutor syncHttpExecutor = this.createSyncExecutor(connectionManager, request, lifeCycleHandler);
        return KOTLIN_COROUTINE_HTTP_EXECUTOR_CREATOR.create(request.getConfiguration(), syncHttpExecutor, syncHttpExecutor.getResponseHandler());
    }

    private HttpBackend.HttpExecutorCreator getHttpExecutorCreator(ForestRequest request) {
        if (request.isAsync()) {
            switch (request.asyncMode()) {
                case PLATFORM: {
                    return this.ASYNC_EXECUTOR_CREATOR;
                }
                case KOTLIN_COROUTINE: {
                    if (AsyncUtil.isEnableCoroutine()) {
                        return this.KOTLIN_COROUTINE_EXECUTOR_CREATOR;
                    }
                    return this.ASYNC_EXECUTOR_CREATOR;
                }
            }
            throw new ForestRuntimeException("Forest not support async mode '[" + request.asyncMode().name() + "]'");
        }
        return this.SYNC_EXECUTOR_CREATOR;
    }

    @Override
    public HttpExecutor createExecutor(ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        HttpBackend.HttpExecutorCreator httpExecutorCreator = this.getHttpExecutorCreator(request);
        return httpExecutorCreator.createExecutor(this.connectionManager, request, lifeCycleHandler);
    }

    static {
        kotlinCoroutineExecutorConstructor = null;
        ASYNC_HTTP_EXECUTOR_CREATOR = AsyncHttpExecutor::new;
        KOTLIN_COROUTINE_HTTP_EXECUTOR_CREATOR = (configuration, syncExecutor, responseHandler) -> {
            try {
                if (kotlinCoroutineExecutorConstructor == null) {
                    kotlinCoroutineExecutorConstructor = Class.forName("com.dtflys.forest.backend.KotlinCoroutineHttpExecutor").getConstructor(ForestConfiguration.class, HttpExecutor.class, ResponseHandler.class);
                }
                return (HttpExecutor)kotlinCoroutineExecutorConstructor.newInstance(configuration, syncExecutor, responseHandler);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ForestRuntimeException(e);
            }
        };
    }

    @FunctionalInterface
    private static interface AsyncHttpExecutorCreator {
        public HttpExecutor create(ForestConfiguration var1, HttpExecutor var2, ResponseHandler var3);
    }
}

