/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend;

import com.dtflys.forest.backend.AsyncAbortPolicy;
import com.dtflys.forest.backend.HttpExecutor;
import com.dtflys.forest.backend.ResponseHandler;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestFuture;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.http.ForestResponseFactory;
import com.dtflys.forest.reflection.MethodLifeCycleHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class AsyncHttpExecutor<T>
implements HttpExecutor {
    public static final Integer DEFAULT_MAX_THREAD_SIZE = 200;
    public static final Integer DEFAULT_MAX_QUEUE_SIZE = 100;
    protected final ForestConfiguration configuration;
    protected final HttpExecutor syncExecutor;
    protected final ResponseHandler responseHandler;
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    protected static ThreadPoolExecutor pool;

    public static synchronized void initAsyncThreads(Integer maxAsyncThreadSize, Integer maxQueueSize) {
        int threadSize = maxAsyncThreadSize != null ? maxAsyncThreadSize : DEFAULT_MAX_THREAD_SIZE;
        int queueSize = maxQueueSize == null ? DEFAULT_MAX_QUEUE_SIZE : maxQueueSize;
        LinkedBlockingQueue<Runnable> queue = queueSize > 0 ? new LinkedBlockingQueue(queueSize) : new SynchronousQueue();
        pool = new ThreadPoolExecutor(threadSize, threadSize, 0L, TimeUnit.MINUTES, queue, tf -> {
            Thread thread = new Thread(tf, "forest-async-" + threadCount.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }, new AsyncAbortPolicy());
    }

    public static int getMaxAsyncThreadSize() {
        return pool.getMaximumPoolSize();
    }

    public static int getAsyncThreadSize() {
        return pool.getPoolSize();
    }

    public AsyncHttpExecutor(ForestConfiguration configuration, HttpExecutor syncExecutor, ResponseHandler responseHandler) {
        this.configuration = configuration;
        this.syncExecutor = syncExecutor;
        this.responseHandler = responseHandler;
    }

    @Override
    public ForestRequest getRequest() {
        return this.syncExecutor.getRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(LifeCycleHandler lifeCycleHandler) {
        if (pool == null) {
            AsyncHttpExecutor asyncHttpExecutor = this;
            synchronized (asyncHttpExecutor) {
                if (pool == null) {
                    AsyncHttpExecutor.initAsyncThreads(this.configuration.getMaxAsyncThreadSize(), this.configuration.getMaxAsyncQueueSize());
                }
            }
        }
        AsyncTask task = new AsyncTask(this.syncExecutor, lifeCycleHandler);
        CompletableFuture future = CompletableFuture.supplyAsync(task, pool);
        ForestFuture forestFuture = new ForestFuture(this.getRequest(), future);
        this.responseHandler.handleFuture(this.getRequest(), forestFuture);
    }

    @Override
    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    @Override
    public ForestResponseFactory getResponseFactory() {
        return this.syncExecutor.getResponseFactory();
    }

    @Override
    public void close() {
    }

    public static synchronized void closePool() {
        if (pool != null) {
            pool.shutdown();
        }
    }

    public static synchronized void restartPool() {
        if (pool != null) {
            pool.shutdown();
            pool = null;
        }
    }

    public static class AsyncTask<T>
    implements Supplier<ForestResponse<T>> {
        private final HttpExecutor executor;
        private final LifeCycleHandler lifeCycleHandler;

        public AsyncTask(HttpExecutor executor, LifeCycleHandler lifeCycleHandler) {
            this.executor = executor;
            this.lifeCycleHandler = lifeCycleHandler;
        }

        public LifeCycleHandler getLifeCycleHandler() {
            return this.lifeCycleHandler;
        }

        @Override
        public ForestResponse get() {
            this.executor.execute(this.lifeCycleHandler);
            if (this.lifeCycleHandler instanceof MethodLifeCycleHandler) {
                ForestResponse result = ((MethodLifeCycleHandler)this.lifeCycleHandler).getResponse();
                return result;
            }
            return null;
        }
    }
}

