/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend;

import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class ContentType {
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String X_WWW_FORM_URLENCODED = "x-www-form-urlencoded";
    public static final String APPLICATION_X_PROTOBUF = "application/x-protobuf";
    private final String type;
    private final String subType;
    private String charset;
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();

    public ContentType(String type, String subType) {
        this.type = type;
        this.subType = subType;
    }

    public ContentType(String contentType) {
        String[] group = contentType.split(";");
        String cty = group[0].trim();
        String[] strs = cty.split("/");
        this.type = strs[0];
        this.subType = strs.length > 1 ? strs[1] : null;
        if (group.length > 1) {
            for (int i = 1; i < group.length; ++i) {
                String chartExpr = group[1];
                String[] expr = chartExpr.split("=");
                if (expr.length <= 1) continue;
                this.parameters.put(expr[0], expr[1]);
                String charsetLabel = expr[0].trim();
                if (!"charset".equalsIgnoreCase(charsetLabel)) continue;
                String charsetValue = expr[1].trim();
                this.charset = charsetValue.replace("\"", "");
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty(this.type) && StringUtils.isEmpty(this.subType);
    }

    public boolean isApplication() {
        return "application".equals(this.type);
    }

    public boolean isFormUrlEncoded() {
        if (this.subType == null) {
            return false;
        }
        return this.isApplication() && this.subType.equals(X_WWW_FORM_URLENCODED);
    }

    public boolean isJson() {
        if (this.subType == null) {
            return false;
        }
        return this.subType.contains("json");
    }

    public boolean isXml() {
        if (this.subType == null) {
            return false;
        }
        return this.subType.contains("xml");
    }

    public boolean isZip() {
        if (this.subType == null) {
            return false;
        }
        return this.subType.contains("zip");
    }

    public boolean isJavaScript() {
        if (this.subType == null) {
            return false;
        }
        return "javascript".equals(this.subType);
    }

    public boolean isOctetStream() {
        if (this.subType == null) {
            return false;
        }
        return "octet-stream".equals(this.subType);
    }

    public boolean isOgg() {
        if (this.subType == null) {
            return false;
        }
        return "ogg".equals(this.subType);
    }

    public boolean isStream() {
        if (this.subType == null) {
            return false;
        }
        return this.subType.contains("stream");
    }

    public boolean isProtobuf() {
        if (this.subType == null) {
            return false;
        }
        return this.subType.contains("protobuf");
    }

    public boolean isBinary() {
        return this.isMultipart() || this.isStream() || this.isImage() || this.isZip() || this.isProtobuf();
    }

    public boolean isTorrent() {
        if (this.subType == null) {
            return false;
        }
        return this.subType.endsWith("torrent");
    }

    public boolean isPdf() {
        if (this.subType == null) {
            return false;
        }
        return "pdf".equals(this.subType);
    }

    public boolean isText() {
        return "text".equals(this.type);
    }

    public boolean isAudio() {
        return "audio".equals(this.type);
    }

    public boolean isImage() {
        return "image".equals(this.type);
    }

    public boolean isMultipart() {
        return "multipart".equals(this.type);
    }

    public boolean isVideo() {
        return "video".equals(this.type);
    }

    public boolean canReadAsString() {
        return this.isJson() || this.isXml() || this.isJavaScript() || this.isText();
    }

    public boolean canReadAsBinaryStream() {
        return this.isAudio() || this.isImage() || this.isMultipart() || this.isVideo() || this.isStream() || this.isPdf() || this.isZip();
    }

    public ForestDataType bodyType() {
        if (this.isFormUrlEncoded()) {
            return ForestDataType.FORM;
        }
        if (this.isJson()) {
            return ForestDataType.JSON;
        }
        if (this.isXml()) {
            return ForestDataType.XML;
        }
        if (this.isMultipart()) {
            return ForestDataType.MULTIPART;
        }
        if (this.canReadAsBinaryStream()) {
            return ForestDataType.BINARY;
        }
        if (this.isProtobuf()) {
            return ForestDataType.PROTOBUF;
        }
        return ForestDataType.TEXT;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type);
        if (StringUtils.isNotEmpty(this.subType)) {
            builder.append("/").append(this.subType);
        }
        if (!this.parameters.isEmpty()) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                builder.append("; ").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return builder.toString();
    }

    public String toStringWithoutParameters() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type);
        if (StringUtils.isNotEmpty(this.subType)) {
            builder.append("/").append(this.subType);
        }
        return builder.toString();
    }
}

