/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend;

import com.dtflys.forest.backend.HttpBackend;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpBackendSelector {
    private static final Map<String, HttpBackend> BACKEND_MAP = new ConcurrentHashMap<String, HttpBackend>();
    private static final Map<String, HttpBackendCreator> BACKEND_CREATOR_MAP = new ConcurrentHashMap<String, HttpBackendCreator>();
    private static final String HTTPCLIENT_BACKEND_NAME = "httpclient";
    private static final String OKHTTP3_BACKEND_NAME = "okhttp3";
    public static final String HTTPCLIENT_CLIENT_CLASS_NAME = "org.apache.http.client.HttpClient";
    public static final String OKHTTP3_CLIENT_CLASS_NAME = "okhttp3.OkHttpClient";
    private static final String HTTPCLIENT_BACKEND_CLASS_NAME = "com.dtflys.forest.backend.httpclient.HttpclientBackend";
    private static final String OKHTTP3_BACKEND_CLASS_NAME = "com.dtflys.forest.backend.okhttp3.OkHttp3Backend";
    private static final HttpBackendCreator HTTPCLIENT_BACKEND_CREATOR = new HttpBackendCreator("com.dtflys.forest.backend.httpclient.HttpclientBackend");
    private static final HttpBackendCreator OKHTTP3_BACKEND_CREATOR = new HttpBackendCreator("com.dtflys.forest.backend.okhttp3.OkHttp3Backend");

    public Map<String, HttpBackend> getAllCreatedBackends() {
        return BACKEND_MAP;
    }

    public HttpBackend select(ForestConfiguration configuration) {
        String backendName = configuration.getBackendName();
        return this.select(backendName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpBackend select(String backendName) {
        HttpBackend backend = null;
        if (StringUtils.isNotEmpty(backendName)) {
            backend = BACKEND_MAP.get(backendName);
        }
        if (backend == null) {
            HttpBackendSelector httpBackendSelector = this;
            synchronized (httpBackendSelector) {
                if (StringUtils.isNotEmpty(backendName)) {
                    backend = BACKEND_MAP.get(backendName);
                }
                if (backend == null) {
                    if (StringUtils.isNotEmpty(backendName)) {
                        HttpBackendCreator backendCreator = BACKEND_CREATOR_MAP.get(backendName);
                        if (backendCreator == null) {
                            throw new ForestRuntimeException("Http setBackend \"" + backendName + "\" can not be found.");
                        }
                        backend = backendCreator.create();
                        if (backend != null) {
                            BACKEND_MAP.put(backendName, backend);
                            return backend;
                        }
                    }
                    if ((backend = this.findOkHttp3BackendInstance()) != null) {
                        BACKEND_MAP.put(OKHTTP3_BACKEND_NAME, backend);
                        return backend;
                    }
                    backend = this.findHttpclientBackendInstance();
                    if (backend != null) {
                        BACKEND_MAP.put(HTTPCLIENT_BACKEND_NAME, backend);
                        return backend;
                    }
                    throw new ForestRuntimeException("Http Backed is undefined.");
                }
            }
        }
        return backend;
    }

    public HttpBackend findHttpclientBackendInstance() {
        try {
            Class.forName(HTTPCLIENT_CLIENT_CLASS_NAME);
            return HTTPCLIENT_BACKEND_CREATOR.create();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public HttpBackend findOkHttp3BackendInstance() {
        try {
            Class.forName(OKHTTP3_CLIENT_CLASS_NAME);
            return OKHTTP3_BACKEND_CREATOR.create();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static {
        BACKEND_CREATOR_MAP.put(HTTPCLIENT_BACKEND_NAME, HTTPCLIENT_BACKEND_CREATOR);
        BACKEND_CREATOR_MAP.put(OKHTTP3_BACKEND_NAME, OKHTTP3_BACKEND_CREATOR);
    }

    static class HttpBackendCreator {
        public String className;

        public HttpBackendCreator(String className) {
            this.className = className;
        }

        public HttpBackend create() {
            try {
                Class<?> klass = Class.forName(this.className);
                return (HttpBackend)klass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ForestRuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new ForestRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new ForestRuntimeException(e);
            }
        }
    }
}

